/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.network.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketLocalizedMessage
implements IMessage {
    protected String translationKey;

    public PacketLocalizedMessage() {
        this.translationKey = "";
    }

    public PacketLocalizedMessage(String key) {
        this.translationKey = key;
    }

    public void fromBytes(ByteBuf buf) {
        this.translationKey = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.translationKey);
    }

    public static class Handler
    implements IMessageHandler<PacketLocalizedMessage, IMessage> {
        public IMessage onMessage(PacketLocalizedMessage message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        private void handle(PacketLocalizedMessage message, MessageContext ctx) {
            EntityPlayerSP entityPlayer = Minecraft.func_71410_x().field_71439_g;
            entityPlayer.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.DARK_PURPLE + I18n.func_135052_a((String)message.translationKey, (Object[])new Object[0])), true);
        }
    }
}

