/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.tiles.devices;

import com.verdantartifice.thaumicwonders.common.blocks.BlocksTW;
import com.verdantartifice.thaumicwonders.common.items.catalysts.ICatalystStone;
import com.verdantartifice.thaumicwonders.common.tiles.base.TileTWInventory;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.ThaumcraftInvHelper;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.lib.utils.BlockStateUtils;
import thaumcraft.common.lib.utils.InventoryUtils;
import thaumcraft.common.tiles.devices.TileBellows;

public class TileCatalyzationChamber
extends TileTWInventory
implements ITickable {
    private static final int PLAY_EFFECTS = 4;
    protected int refineTime = 0;
    protected int maxRefineTime = 0;
    protected int speedyTime = 0;
    protected int facingX = -5;
    protected int facingZ = -5;
    protected ItemStack equippedStone = ItemStack.field_190927_a;

    public TileCatalyzationChamber() {
        super(32);
    }

    public ItemStack getEquippedStone() {
        return this.equippedStone;
    }

    public boolean setEquippedStone(ItemStack stack) {
        if (stack != null && !stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof ICatalystStone) {
                this.equippedStone = stack;
                return true;
            }
            return false;
        }
        this.equippedStone = stack;
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n() - 1.3, (double)this.func_174877_v().func_177956_o() - 1.3, (double)this.func_174877_v().func_177952_p() - 1.3, (double)this.func_174877_v().func_177958_n() + 2.3, (double)this.func_174877_v().func_177956_o() + 2.3, (double)this.func_174877_v().func_177952_p() + 1.3);
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.UP ? super.func_180463_a(side) : new int[]{};
    }

    @Override
    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.refineTime = compound.func_74765_d("RefineTime");
        this.speedyTime = compound.func_74765_d("SpeedyTime");
        this.equippedStone = new ItemStack(compound.func_74775_l("EquippedStone"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74777_a("RefineTime", (short)this.refineTime);
        compound.func_74777_a("SpeedyTime", (short)this.speedyTime);
        compound.func_74782_a("EquippedStone", (NBTBase)this.equippedStone.func_77955_b(new NBTTagCompound()));
        return compound;
    }

    public void func_73660_a() {
        if (this.facingX == -5) {
            this.setFacing();
        }
        if (!this.field_145850_b.field_72995_K) {
            int slot;
            boolean refinedFlag = false;
            if (this.refineTime > 0) {
                --this.refineTime;
                refinedFlag = true;
            }
            if (this.maxRefineTime <= 0) {
                this.maxRefineTime = this.calcRefineTime();
            }
            if (this.refineTime > this.maxRefineTime) {
                this.refineTime = this.maxRefineTime;
            }
            if (this.refineTime <= 0 && refinedFlag) {
                for (slot = 0; slot < this.func_70302_i_(); ++slot) {
                    ItemStack resultStack;
                    ItemStack stack = this.func_70301_a(slot);
                    if (stack == null || stack.func_190926_b()) continue;
                    ICatalystStone stone = null;
                    if (this.getEquippedStone() != null && !this.getEquippedStone().func_190926_b() && this.getEquippedStone().func_77973_b() instanceof ICatalystStone) {
                        stone = (ICatalystStone)this.getEquippedStone().func_77973_b();
                    }
                    ItemStack itemStack = resultStack = stone != null ? stone.getRefiningResult(stack) : stack;
                    if (resultStack == null || resultStack.func_190926_b()) {
                        resultStack = stack;
                    }
                    if (this.getEquippedStone().func_96631_a(1, this.field_145850_b.field_73012_v, null)) {
                        this.getEquippedStone().func_190918_g(1);
                    }
                    if (this.speedyTime > 0) {
                        --this.speedyTime;
                    }
                    this.ejectItem(resultStack.func_77946_l());
                    this.field_145850_b.func_175641_c(this.func_174877_v(), BlocksTW.CATALYZATION_CHAMBER, 4, 0);
                    if (stone != null && this.field_145850_b.field_73012_v.nextInt(stone.getFluxChance()) == 0) {
                        AuraHelper.polluteAura((World)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(this.getFacing().func_176734_d()), (float)1.0f, (boolean)true);
                    }
                    this.func_70298_a(slot, resultStack.func_190916_E());
                    break;
                }
            }
            if (this.speedyTime <= 0) {
                this.speedyTime = (int)AuraHelper.drainVis((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (float)20.0f, (boolean)false);
            }
            if (this.refineTime == 0 && !refinedFlag) {
                for (slot = 0; slot < this.func_70302_i_(); ++slot) {
                    if (this.canRefine(this.func_70301_a(slot))) {
                        this.refineTime = this.maxRefineTime = this.calcRefineTime();
                        break;
                    }
                    this.ejectItem(this.func_70301_a(slot).func_77946_l());
                    this.func_70299_a(slot, ItemStack.field_190927_a);
                }
            }
        }
    }

    public ItemStack addItemsToInventory(ItemStack items) {
        if (this.canRefine(items)) {
            return ThaumcraftInvHelper.insertStackAt((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (EnumFacing)EnumFacing.UP, (ItemStack)items, (boolean)false);
        }
        this.ejectItem(items);
        return ItemStack.field_190927_a;
    }

    private boolean canRefine(ItemStack stack) {
        ICatalystStone stone = null;
        if (this.getEquippedStone() != null && !this.getEquippedStone().func_190926_b() && this.getEquippedStone().func_77973_b() instanceof ICatalystStone) {
            stone = (ICatalystStone)this.getEquippedStone().func_77973_b();
        }
        if (stone != null) {
            ItemStack resultStack = stone.getRefiningResult(stack);
            return resultStack != null && !resultStack.func_190926_b();
        }
        return false;
    }

    private void ejectItem(ItemStack itemStack) {
        if (!itemStack.func_190926_b()) {
            EnumFacing facing = BlockStateUtils.getFacing((int)this.func_145832_p()).func_176734_d();
            InventoryUtils.ejectStackAt((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (EnumFacing)facing, (ItemStack)itemStack);
        }
    }

    private int calcRefineTime() {
        int count = this.getBellows();
        int bonus = count > 0 ? (20 - (count - 1)) * count : 0;
        return Math.max(10, (this.speedyTime > 0 ? 80 : 140) - bonus);
    }

    private int getBellows() {
        int count = 0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            BlockPos tilePos;
            TileEntity tile;
            if (dir == EnumFacing.UP || (tile = this.field_145850_b.func_175625_s(tilePos = this.field_174879_c.func_177967_a(dir, 2))) == null || !(tile instanceof TileBellows) || BlockStateUtils.getFacing((IBlockState)this.field_145850_b.func_180495_p(tilePos)) != dir.func_176734_d() || this.field_145850_b.func_175687_A(tilePos) != 0) continue;
            ++count;
        }
        return Math.min(4, count);
    }

    private void setFacing() {
        EnumFacing face = this.getFacing().func_176734_d();
        this.facingX = face.func_82601_c();
        this.facingZ = face.func_82599_e();
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 4) {
            if (this.field_145850_b.field_72995_K) {
                ICatalystStone stone = null;
                if (this.getEquippedStone() != null && !this.getEquippedStone().func_190926_b() && this.getEquippedStone().func_77973_b() instanceof ICatalystStone) {
                    stone = (ICatalystStone)this.getEquippedStone().func_77973_b();
                }
                if (stone != null) {
                    for (int i = 0; i < 5; ++i) {
                        BlockPos targetPos = this.func_174877_v().func_177967_a(this.getFacing().func_176734_d(), 2);
                        FXDispatcher.INSTANCE.visSparkle(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), targetPos.func_177958_n(), targetPos.func_177956_o(), targetPos.func_177952_p(), stone.getSparkleColor());
                    }
                }
            }
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.8f, 0.9f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f);
            return true;
        }
        return super.func_145842_c(id, type);
    }
}

