/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.letsleepingdogslie.common;

import java.util.Map;
import me.ichun.letsleepingdogslie.common.core.TickHandlerClient;
import me.ichun.letsleepingdogslie.common.model.ModelWolf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderWolf;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;

@Mod(modid="dogslie", name="LetSleepingDogsLie", version="1.0.2", certificateFingerprint="4db5c2bd1b556f252a5b8b54b256d381b2a0a6b8", clientSideOnly=true, acceptableRemoteVersions="*", dependencies="required-after:forge@[13.19.0.2141,)", acceptedMinecraftVersions="[1.12,1.13)")
public class LetSleepingDogsLie {
    public static final String MODID = "dogslie";
    public static final String NAME = "LetSleepingDogsLie";
    public static final String VERSION = "1.0.2";
    public static final String CERT_FINGERPRINT = "4db5c2bd1b556f252a5b8b54b256d381b2a0a6b8";
    @Mod.Instance(value="dogslie")
    public static LetSleepingDogsLie instance;
    private static Logger logger;
    public static TickHandlerClient tickHandlerClient;
    public static boolean dogsSpawnLying;
    public static int timeBeforeLie;
    public static float rangeBeforeGettingUp;
    public static int getsUpTo;
    public static boolean attemptModWolfSupport;
    public static String[] enabledPoses;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        dogsSpawnLying = config.getBoolean("dogsSpawnLying", "general", dogsSpawnLying, I18n.func_74838_a((String)"lsdl.config.dogsSpawnLying"));
        timeBeforeLie = config.getInt("timeBeforeLie", "general", timeBeforeLie, 1, 6000000, I18n.func_74838_a((String)"lsdl.config.timeBeforeLie"));
        rangeBeforeGettingUp = config.getFloat("rangeBeforeGettingUp", "general", rangeBeforeGettingUp, 0.0f, 32.0f, I18n.func_74838_a((String)"lsdl.config.rangeBeforeGettingUp"));
        getsUpTo = config.getInt("getsUpToLie", "general", getsUpTo, 0, 3, I18n.func_74838_a((String)"lsdl.config.getsUpTo"));
        enabledPoses = config.getStringList("enabledPoses", "general", enabledPoses, I18n.func_74838_a((String)"lsdl.config.enabledPoses"), enabledPoses, enabledPoses);
        attemptModWolfSupport = config.getBoolean("attemptModWolfSupport", "general", attemptModWolfSupport, I18n.func_74838_a((String)"lsdl.config.attemptModWolfSupport"));
        if (config.hasChanged()) {
            config.save();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (Loader.isModLoaded((String)"doggytalents")) {
            logger.error("Detected Doggy Talents installed, they have their own lying down mechanic, meaning we're incompatible with them, so we won't do anything!");
        } else {
            this.init();
        }
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        if (event.getSource() != null && event.getSource().isFile()) {
            logger.warn("The file " + event.getSource().getName() + " has been modified. Support for the mod will not be provided.");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void init() {
        Render renderer;
        boolean replaced = false;
        if (attemptModWolfSupport) {
            Map entityRenderMap = Minecraft.func_71410_x().func_175598_ae().field_78729_o;
            for (Map.Entry e : entityRenderMap.entrySet()) {
                if (e.getKey() == EntityWolf.class || !(e.getValue() instanceof RenderWolf) || !((RenderWolf)e.getValue()).field_77045_g.getClass().equals(net.minecraft.client.model.ModelWolf.class)) continue;
                ((RenderWolf)e.getValue()).field_77045_g = new ModelWolf();
                replaced = true;
                logger.info("ModWolfSupport: Overrode " + ((Render)e.getValue()).getClass().getSimpleName() + " model.");
            }
        }
        if ((renderer = Minecraft.func_71410_x().func_175598_ae().func_78715_a(EntityWolf.class)) instanceof RenderWolf) {
            RenderWolf renderWolf = (RenderWolf)renderer;
            if (renderWolf.field_77045_g.getClass().equals(net.minecraft.client.model.ModelWolf.class)) {
                renderWolf.field_77045_g = new ModelWolf();
                replaced = true;
                logger.info("Overrode Vanilla Wolf model. We are ready!");
            } else {
                logger.error("RenderWolf model is not ModelWolf, so we won't do anything!");
            }
        } else {
            logger.error("Wolf renderer isn't RenderWolf, so we won't do anything!");
        }
        if (replaced) {
            tickHandlerClient = new TickHandlerClient();
            MinecraftForge.EVENT_BUS.register((Object)tickHandlerClient);
        }
    }

    static {
        dogsSpawnLying = true;
        timeBeforeLie = 300;
        rangeBeforeGettingUp = 3.0f;
        getsUpTo = 1;
        attemptModWolfSupport = true;
        enabledPoses = new String[]{"forelegStraight", "forelegSprawled", "forelegSprawledBack", "forelegSkewed", "forelegSide", "hindlegStraight", "hindlegStraightBack", "hindlegSprawled", "hindlegSprawledBack", "hindlegSide"};
    }
}

