/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.block.decorative;

import com.github.sokyranthedragon.mia.MiaCreativeTab;
import com.github.sokyranthedragon.mia.block.IAutoRegisterBlock;
import com.github.sokyranthedragon.mia.config.MiaConfig;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlockMiaWallFutureMC
extends Block
implements IAutoRegisterBlock {
    private static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    private static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    private static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    private static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    private static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    private static final AxisAlignedBB[] AABB_BY_INDEX = new AxisAlignedBB[]{new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.0, 0.0, 0.25, 0.75, 1.0, 1.0), new AxisAlignedBB(0.25, 0.0, 0.0, 0.75, 1.0, 0.75), new AxisAlignedBB(0.3125, 0.0, 0.0, 0.6875, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.75, 1.0, 0.75), new AxisAlignedBB(0.0, 0.0, 0.0, 0.75, 1.0, 1.0), new AxisAlignedBB(0.25, 0.0, 0.25, 1.0, 1.0, 0.75), new AxisAlignedBB(0.25, 0.0, 0.25, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.3125, 1.0, 0.875, 0.6875), new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 1.0, 1.0), new AxisAlignedBB(0.25, 0.0, 0.0, 1.0, 1.0, 0.75), new AxisAlignedBB(0.25, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.75), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};
    private static final AxisAlignedBB[] CLIP_AABB_BY_INDEX = new AxisAlignedBB[AABB_BY_INDEX.length];
    private final IBlockState parent;

    public BlockMiaWallFutureMC(String variant, @Nullable CreativeTabs creativeTab, IBlockState parent, MapColor mapColor) {
        super(parent.func_185904_a(), mapColor);
        this.parent = parent;
        if (MiaConfig.miaCreativeTab) {
            this.func_149647_a(MiaCreativeTab.INSTANCE);
        } else if (creativeTab != null) {
            this.func_149647_a(creativeTab);
        }
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
        this.setRegistryName(new ResourceLocation("mia", variant));
        this.func_149663_c(variant);
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return this.parent.func_177230_c().getExplosionResistance(world, pos, exploder, explosion) * 5.0f / 3.0f;
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        return this.parent.func_185887_b(worldIn, pos);
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return this.parent.func_177230_c().getSoundType(this.parent, world, pos, entity);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB_BY_INDEX[Companion.getAABBIndex(this.func_176221_a(state, source, pos))];
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        IBlockState actualState = state;
        if (!isActualState) {
            actualState = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        }
        Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CLIP_AABB_BY_INDEX[Companion.getAABBIndex(actualState)]);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return CLIP_AABB_BY_INDEX[Companion.getAABBIndex(this.func_176221_a(blockState, worldIn, pos))];
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    private boolean canConnectTo(IBlockAccess worldIn, BlockPos pos, EnumFacing facing) {
        IBlockState state = worldIn.func_180495_p(pos);
        Block block = state.func_177230_c();
        BlockFaceShape shape = state.func_193401_d(worldIn, pos, facing);
        boolean flag = shape == BlockFaceShape.MIDDLE_POLE_THICK || shape == BlockFaceShape.MIDDLE_POLE && block instanceof BlockFenceGate;
        return !Companion.isExceptBlockForAttachWithPiston(block) && shape == BlockFaceShape.SOLID || flag;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side != EnumFacing.DOWN || super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean isNorth = this.canWallConnectTo(worldIn, pos, EnumFacing.NORTH);
        boolean isEast = this.canWallConnectTo(worldIn, pos, EnumFacing.EAST);
        boolean isSouth = this.canWallConnectTo(worldIn, pos, EnumFacing.SOUTH);
        boolean isWest = this.canWallConnectTo(worldIn, pos, EnumFacing.WEST);
        boolean isPole = isNorth && !isEast && isSouth && !isWest || !isNorth && isEast && !isSouth && isWest;
        return state.func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(!isPole || !worldIn.func_175623_d(pos.func_177984_a()))).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(isNorth)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(isEast)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(isSouth)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(isWest));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{UP, NORTH, EAST, WEST, SOUTH});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face != EnumFacing.UP && face != EnumFacing.DOWN ? BlockFaceShape.MIDDLE_POLE_THICK : BlockFaceShape.CENTER_BIG;
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        BlockPos offset = pos.func_177972_a(facing);
        EnumFacing opposite = facing.func_176734_d();
        return this.canConnectTo(world, offset, opposite);
    }

    private boolean canWallConnectTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        EnumFacing opposite;
        BlockPos other = pos.func_177972_a(facing);
        IBlockState otherState = world.func_180495_p(other);
        Block block = otherState.func_177230_c();
        return block.canBeConnectedTo(world, other, facing.func_176734_d()) || this.canConnectTo(world, other, opposite = facing.func_176734_d());
    }

    static {
        for (int i = 0; i < AABB_BY_INDEX.length; ++i) {
            BlockMiaWallFutureMC.CLIP_AABB_BY_INDEX[i] = AABB_BY_INDEX[i].func_186666_e(1.5);
        }
    }

    private static class Companion {
        private Companion() {
        }

        public static int getAABBIndex(IBlockState state) {
            int i = 0;
            if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
                i |= 1 << EnumFacing.NORTH.func_176736_b();
            }
            if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
                i |= 1 << EnumFacing.EAST.func_176736_b();
            }
            if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
                i |= 1 << EnumFacing.SOUTH.func_176736_b();
            }
            if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
                i |= 1 << EnumFacing.WEST.func_176736_b();
            }
            return i;
        }

        public static boolean isExceptBlockForAttachWithPiston(Block block) {
            return BlockMiaWallFutureMC.func_193382_c((Block)block) || Blocks.field_180401_cv.equals(block) || Blocks.field_150440_ba.equals(block) || Blocks.field_150423_aK.equals(block) || Blocks.field_150428_aP.equals(block);
        }
    }
}

