/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.commands;

import com.github.sokyranthedragon.mia.utilities.size.SizeUtils;
import com.google.common.primitives.Floats;
import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraft.util.math.BlockPos;

public class CommandSize
extends CommandBase {
    @Nonnull
    public String func_71517_b() {
        return "size";
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public String func_71518_a(ICommandSender sender) {
        if (sender.func_184102_h() != null && this.canUseCommandOp(sender.func_184102_h(), sender)) {
            return "mia.commands.size.usage_op";
        }
        return "mia.commands.size.usage";
    }

    public int func_82362_a() {
        return 0;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    @ParametersAreNonnullByDefault
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP entityPlayer;
        block15: {
            boolean isOp = this.canUseCommandOp(server, sender);
            if (sender.func_174793_f() instanceof EntityPlayer) {
                EntityLivingBase player = (EntityLivingBase)sender.func_174793_f();
                if (!isOp) {
                    CommandSize.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"mia.commands.size.success_1", (Object[])new Object[]{sender.func_70005_c_(), Float.valueOf(SizeUtils.getEntitySize((EntityLivingBase)sender.func_174793_f())), Float.valueOf(player.field_70131_O)});
                    return;
                }
                if (args.length == 0) {
                    CommandSize.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"mia.commands.size.success_1", (Object[])new Object[]{sender.func_70005_c_(), Float.valueOf(SizeUtils.getEntitySize((EntityLivingBase)sender.func_174793_f())), Float.valueOf(player.field_70131_O)});
                    return;
                }
            } else if (args.length == 0) {
                if (isOp) {
                    throw new WrongUsageException("mia.commands.size.usage_op", new Object[0]);
                }
                throw new WrongUsageException("mia.commands.size.usage", new Object[0]);
            }
            if (!isOp) {
                throw new CommandException("commands.generic.permission", new Object[0]);
            }
            entityPlayer = null;
            try {
                entityPlayer = CommandSize.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
            }
            catch (PlayerNotFoundException e) {
                if (sender.func_174793_f() instanceof EntityPlayer) break block15;
                throw e;
            }
        }
        if (entityPlayer == null) {
            float targetSize;
            try {
                targetSize = CommandSize.parseFloat(args[0]);
            }
            catch (NumberInvalidException e) {
                throw new CommandException("mia.commands.size.failure_1", new Object[]{args[0]});
            }
            entityPlayer = (EntityPlayer)sender.func_174793_f();
            SizeUtils.setEntitySize((EntityLivingBase)entityPlayer, targetSize);
            CommandSize.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"mia.commands.size.success_2", (Object[])new Object[]{entityPlayer.func_70005_c_(), Float.valueOf(SizeUtils.getEntitySize((EntityLivingBase)entityPlayer))});
        } else if (args.length == 1) {
            CommandSize.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"mia.commands.size.success_1", (Object[])new Object[]{entityPlayer.func_70005_c_(), Float.valueOf(SizeUtils.getEntitySize((EntityLivingBase)entityPlayer)), Float.valueOf(entityPlayer.field_70131_O)});
        } else {
            float targetSize = CommandSize.parseFloat(args[1]);
            SizeUtils.setEntitySize((EntityLivingBase)entityPlayer, targetSize);
            CommandSize.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"mia.commands.size.success_2", (Object[])new Object[]{entityPlayer.func_70005_c_(), Float.valueOf(SizeUtils.getEntitySize((EntityLivingBase)entityPlayer))});
        }
    }

    @Nonnull
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1 && this.canUseCommandOp(server, sender)) {
            return CommandSize.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        return Collections.emptyList();
    }

    private static float parseFloat(String input) throws NumberInvalidException {
        try {
            float number = Float.parseFloat(input);
            if (!Floats.isFinite((float)number)) {
                throw new NumberInvalidException("commands.generic.num.invalid", new Object[]{input});
            }
            return number;
        }
        catch (NumberFormatException e) {
            throw new NumberInvalidException("commands.generic.num.invalid", new Object[]{input});
        }
    }

    private boolean canUseCommandOp(MinecraftServer server, ICommandSender sender) {
        boolean isPlayer = sender.func_174793_f() instanceof EntityPlayerMP;
        if (!(sender.func_174793_f() instanceof EntityLivingBase) && !isPlayer) {
            return true;
        }
        if (!isPlayer) {
            return false;
        }
        if (server.func_71264_H()) {
            return true;
        }
        EntityPlayerMP player = (EntityPlayerMP)sender.func_174793_f();
        GameProfile gameProfile = player.func_146103_bH();
        if (!server.func_184103_al().func_152596_g(gameProfile)) {
            return false;
        }
        UserListOpsEntry userListOpSentry = (UserListOpsEntry)server.func_184103_al().func_152603_m().func_152683_b((Object)gameProfile);
        return userListOpSentry != null && userListOpSentry.func_152644_a() >= this.func_82362_a();
    }
}

