/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.core;

import com.github.sokyranthedragon.mia.block.IAutoRegisterBlock;
import com.github.sokyranthedragon.mia.block.base.BlockBaseDoor;
import com.github.sokyranthedragon.mia.block.base.BlockBaseGlass;
import com.github.sokyranthedragon.mia.block.decorative.BlockDeadFlower;
import com.github.sokyranthedragon.mia.block.decorative.BlockGoldenTorch;
import com.github.sokyranthedragon.mia.block.decorative.BlockPackedPaper;
import com.github.sokyranthedragon.mia.block.decorative.BlockRedstoneLantern;
import com.github.sokyranthedragon.mia.block.decorative.SandstoneEntry;
import com.github.sokyranthedragon.mia.config.GenericAdditionsConfig;
import com.github.sokyranthedragon.mia.utilities.RegisterUtils;
import com.github.sokyranthedragon.mia.utilities.annotations.FieldsAreNullableByDefault;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@FieldsAreNullableByDefault
public class MiaBlocks {
    @Nonnull
    public static final List<Block> blocks = new LinkedList<Block>();
    public static Block armoredGlass = null;
    public static Block packedPaper = null;
    public static Block torchGold = null;
    public static BlockBush flowerDead = null;
    public static Block doorStone = null;
    public static Block redstoneLantern = null;
    public static Block eggSorter = null;
    public static Block pixieDustExtractor = null;
    public static Block voidCreator = null;
    public static Block blockBotaniaSpecialFlower = null;
    public static SandstoneEntry whiteSandstone = null;

    private MiaBlocks() {
    }

    public static <T extends Block> T registerBlock(T block) {
        return MiaBlocks.registerBlock(block, null);
    }

    public static <T extends Block> T registerBlock(T block, @Nullable IForgeRegistry<Block> registry) {
        if (registry != null) {
            registry.register(block);
        }
        blocks.add(block);
        return block;
    }

    public static void initMiaBlocks() {
        if (GenericAdditionsConfig.enableEvtp) {
            if (GenericAdditionsConfig.evtp.armoredGlassEnabled) {
                armoredGlass = MiaBlocks.registerBlock(new BlockBaseGlass("armored_glass", CreativeTabs.field_78030_b, false).func_149711_c(40.0f).func_149752_b(1750.0f));
                armoredGlass.setHarvestLevel("pickaxe", 0);
            }
            if (GenericAdditionsConfig.evtp.packedPaperEnabled) {
                packedPaper = MiaBlocks.registerBlock(new BlockPackedPaper());
            }
            if (GenericAdditionsConfig.evtp.goldenTorchEnabled) {
                torchGold = MiaBlocks.registerBlock(new BlockGoldenTorch());
            }
            if (GenericAdditionsConfig.evtp.deadFlowerEnabled) {
                flowerDead = MiaBlocks.registerBlock(new BlockDeadFlower());
            }
            if (GenericAdditionsConfig.evtp.stoneDoorsEnabled) {
                doorStone = MiaBlocks.registerBlock(new BlockBaseDoor(Material.field_151576_e, "door_stone", CreativeTabs.field_78028_d, SoundType.field_185851_d).func_149711_c(4.0f));
                doorStone.setHarvestLevel("pickaxe", -1);
            }
            if (GenericAdditionsConfig.evtp.redstoneLanternEnabled) {
                redstoneLantern = MiaBlocks.registerBlock(new BlockRedstoneLantern());
            }
        }
    }

    public static void registerMiaBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        for (Block block : blocks) {
            if (!(block instanceof IAutoRegisterBlock) || !((IAutoRegisterBlock)block).registerBlock()) continue;
            registry.register((IForgeRegistryEntry)block);
        }
    }

    public static void registerMiaItemblocks(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        for (Block block : blocks) {
            if (!(block instanceof IAutoRegisterBlock) || !((IAutoRegisterBlock)block).registerItemblock()) continue;
            RegisterUtils.registerItemblock(block, (IForgeRegistry<Item>)registry);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerMiaItemblockRenderers() {
        for (Block block : blocks) {
            if (!(block instanceof IAutoRegisterBlock) || !((IAutoRegisterBlock)block).registerItemblockRenderer()) continue;
            RegisterUtils.registerItemblockRenderer(block);
        }
    }
}

