/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.enchantments;

import com.github.sokyranthedragon.mia.enchantments.EnchantmentKobold;
import com.github.sokyranthedragon.mia.enchantments.EnchantmentShrinking;
import com.github.sokyranthedragon.mia.enchantments.EnchantmentSizeSteal;
import com.github.sokyranthedragon.mia.integrations.thermalexpansion.ThermalExpansion;
import com.github.sokyranthedragon.mia.utilities.size.SizeUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="mia")
public class ModEnchantments {
    public static final Enchantment SHRINKING;
    public static final Enchantment SIZE_STEAL;
    public static final Enchantment KOBOLD;

    private static Enchantment addEnchantment(Enchantment enchantment, String name) {
        return ((Enchantment)enchantment.setRegistryName(name)).func_77322_b(name);
    }

    @SubscribeEvent
    public static void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        if (SizeUtils.isSizeComponentEnabled) {
            IForgeRegistry registry = event.getRegistry();
            registry.register((IForgeRegistryEntry)SHRINKING);
            registry.register((IForgeRegistryEntry)SIZE_STEAL);
            registry.register((IForgeRegistryEntry)KOBOLD);
            ThermalExpansion.addEnchantingRecipe(new ItemStack(Items.field_185161_cS), "mia:shrinking", 0);
            ThermalExpansion.addEnchantingRecipe(new ItemStack(Items.field_185162_cT), "mia:size_steal", 3);
            ThermalExpansion.addEnchantingRecipe(new ItemStack(Blocks.field_185766_cS), "mia:kobold", 4);
        }
    }

    static {
        if (SizeUtils.isSizeComponentEnabled) {
            SHRINKING = ModEnchantments.addEnchantment(new EnchantmentShrinking(), "shrinking");
            SIZE_STEAL = ModEnchantments.addEnchantment(new EnchantmentSizeSteal(), "size_steal");
            KOBOLD = ModEnchantments.addEnchantment(new EnchantmentKobold(), "kobold");
        } else {
            SHRINKING = null;
            SIZE_STEAL = null;
            KOBOLD = null;
        }
    }
}

