/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.events;

import com.github.sokyranthedragon.mia.config.GenericAdditionsConfig;
import com.github.sokyranthedragon.mia.core.MiaItems;
import com.github.sokyranthedragon.mia.enchantments.EnchantmentKobold;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.utilities.BaublesUtils;
import com.github.sokyranthedragon.mia.utilities.size.ClimbingHandler;
import com.github.sokyranthedragon.mia.utilities.size.SizeOreDictionaryUtils;
import com.github.sokyranthedragon.mia.utilities.size.SizeUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockClay;
import net.minecraft.block.BlockConcretePowder;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockGrassPath;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockMycelium;
import net.minecraft.block.BlockRedFlower;
import net.minecraft.block.BlockReed;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockSoulSand;
import net.minecraft.block.BlockWeb;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class Size_BaseEvents {
    public static DamageSource causeCrushingDamage(EntityLivingBase entity) {
        return new EntityDamageSource("mia.crushing", (Entity)entity);
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!SizeUtils.isSizeComponentEnabled || !GenericAdditionsConfig.sizeModule.giantsCrushEntities || event.getEntityLiving().func_70093_af()) {
            return;
        }
        List<String> bannedEntities = Arrays.asList(GenericAdditionsConfig.sizeModule.bannedEntitiesCrushing);
        ResourceLocation key = EntityList.func_191301_a((Entity)event.getEntityLiving());
        if (key != null && bannedEntities.contains(key.toString())) {
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        boolean canPlayerCrush = GenericAdditionsConfig.sizeModule.canPlayersCrushOtherPlayers && entity instanceof EntityPlayer;
        boolean canNonPlayerCrush = GenericAdditionsConfig.sizeModule.onlyHostileMobsCanCrush || entity instanceof EntityMob;
        for (EntityLivingBase other : entity.field_70170_p.func_72872_a(EntityLivingBase.class, entity.func_174813_aQ())) {
            ResourceLocation keyOther;
            boolean canCrush = canNonPlayerCrush;
            if (other instanceof EntityPlayer) {
                canCrush = canPlayerCrush;
            }
            if (!canCrush || !(entity.field_70131_O / other.field_70131_O >= 4.0f) || entity.func_184187_bx() == entity || (keyOther = EntityList.func_191301_a((Entity)other)) != null && bannedEntities.contains(keyOther.toString())) continue;
            other.func_70097_a(Size_BaseEvents.causeCrushingDamage(entity), entity.field_70131_O - other.field_70131_O);
        }
    }

    @SubscribeEvent
    public static void onHarvest(PlayerEvent.BreakSpeed event) {
        if (!SizeUtils.isSizeComponentEnabled) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        float size = SizeUtils.getEntitySize((EntityLivingBase)player);
        if (size < 1.0f) {
            size = EnchantmentKobold.getSizeModifier(player, size);
        }
        event.setNewSpeed(event.getOriginalSpeed() * size);
    }

    @SubscribeEvent
    public static void onEntityJump(LivingEvent.LivingJumpEvent event) {
        if (!SizeUtils.isSizeComponentEnabled) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            float sizeModifier = SizeUtils.getEntitySize((EntityLivingBase)player);
            if ((player.func_70093_af() || player.func_70051_ag() || EnchantmentKobold.getSizeModifier(player, sizeModifier) > 0.0f) && player.field_70131_O < 1.8f) {
                player.field_70181_x = 0.42f;
            } else {
                float size = MathHelper.func_76129_c((float)sizeModifier);
                size = MathHelper.func_76131_a((float)size, (float)0.65f, (float)size);
                player.field_70181_x *= (double)size;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerFall(LivingFallEvent event) {
        if (!SizeUtils.isSizeComponentEnabled) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            float height = SizeUtils.getEntitySize((EntityLivingBase)player);
            if (height < 0.25f || height <= 0.5f && BaublesUtils.isBaubleActiveAFO(player, MiaItems.koboldRing)) {
                event.setDistance(0.0f);
            } else {
                float scaledDamageThreshold = player.field_70131_O / 1.8f;
                float scaledSafeFallDistance = 3.0f * scaledDamageThreshold;
                if (event.getDistance() > scaledSafeFallDistance) {
                    event.setDistance(3.0f + (event.getDistance() - scaledSafeFallDistance) / scaledDamageThreshold);
                } else {
                    event.setDistance(0.0f);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerTickFirst(TickEvent.PlayerTickEvent event) {
        if (!SizeUtils.isSizeComponentEnabled) {
            return;
        }
        event.player.field_70138_W = 0.6f;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ItemStack ring;
        if (!SizeUtils.isSizeComponentEnabled) {
            return;
        }
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        if (event.side == Side.SERVER) {
            EnchantmentKobold.checkKoboldEnchantment(player);
        }
        if (ModIds.AETHER.isLoaded && MiaItems.koboldRing != null && !(ring = BaublesUtils.getAetherStack(player, MiaItems.koboldRing)).func_190926_b()) {
            MiaItems.koboldRing.onWornTick(ring, (EntityLivingBase)player);
        }
        float height = SizeUtils.getEntitySize((EntityLivingBase)player);
        float koboldHeight = EnchantmentKobold.getSizeModifier(player, height);
        player.field_70138_W *= koboldHeight;
        player.field_70747_aH *= koboldHeight;
        if (height < 0.5f) {
            BlockPos pos = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            float ratio = height / 2.0f;
            if (GenericAdditionsConfig.sizeModule.doRosesHurtSmallPlayer && (block instanceof BlockRedFlower || state == Blocks.field_150398_cm.func_176223_P().func_177226_a((IProperty)BlockDoublePlant.field_176493_a, (Comparable)BlockDoublePlant.EnumPlantType.ROSE))) {
                player.func_70097_a(DamageSource.field_76367_g, 1.0f);
            }
            if (GenericAdditionsConfig.sizeModule.doPlantsSlowSmallPlayer && !player.field_71075_bZ.field_75100_b && (block instanceof BlockBush || block instanceof BlockCarpet || block instanceof BlockReed || block instanceof BlockSnow || block instanceof BlockWeb || block instanceof BlockSoulSand)) {
                player.field_70159_w *= (double)ratio;
                if (block instanceof BlockWeb) {
                    player.field_70181_x *= (double)ratio;
                }
                player.field_70179_y *= (double)ratio;
            }
        }
        if (height <= 0.25f || height <= 0.5f && BaublesUtils.isBaubleActiveAFO(player, MiaItems.koboldRing)) {
            EnumFacing facing = player.func_174811_aO();
            BlockPos pos = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            IBlockState state = world.func_180495_p(pos.func_177982_a(0, 0, 0).func_177972_a(facing));
            Block block = state.func_177230_c();
            if (GenericAdditionsConfig.sizeModule.canClimbSomeBlocks && (block instanceof BlockDirt || block instanceof BlockGrass || block instanceof BlockMycelium || block instanceof BlockLeaves || block instanceof BlockSand || block instanceof BlockSoulSand || block instanceof BlockConcretePowder || block instanceof BlockFarmland || block instanceof BlockGrassPath || block instanceof BlockGravel || block instanceof BlockClay) && ClimbingHandler.canClimb(player, facing) && player.field_70123_F) {
                if (!player.func_70093_af()) {
                    player.field_70181_x = 0.1;
                }
                if (player.func_70093_af()) {
                    player.field_70181_x = 0.0;
                }
            }
            if (GenericAdditionsConfig.sizeModule.canClimbWithSlime || GenericAdditionsConfig.sizeModule.canGlideWithPaper) {
                block0: for (ItemStack stack : player.func_184214_aD()) {
                    if (GenericAdditionsConfig.sizeModule.canClimbWithSlime && SizeOreDictionaryUtils.isItemSlime(stack) && ClimbingHandler.canClimb(player, facing) && player.field_70123_F) {
                        if (!player.func_70093_af()) {
                            player.field_70181_x = 0.1;
                        }
                        if (player.func_70093_af()) {
                            player.field_70181_x = 0.0;
                        }
                    }
                    if (!GenericAdditionsConfig.sizeModule.canGlideWithPaper || !SizeOreDictionaryUtils.isItemPaper(stack) || player.field_70122_E) continue;
                    player.field_70747_aH = 0.035f;
                    player.field_70143_R = 0.0f;
                    if (player.field_70181_x < 0.0) {
                        player.field_70181_x *= 0.6;
                    }
                    if (player.func_70093_af()) {
                        player.field_70747_aH *= 3.5f;
                    }
                    if (!GenericAdditionsConfig.sizeModule.hotBlocksGiveLift || player.func_70093_af()) continue;
                    double blockY = player.field_70163_u;
                    if (blockY >= 256.0) {
                        blockY -= blockY - 256.0;
                    }
                    while (blockY >= 0.0 && player.field_70163_u - blockY < 25.0) {
                        Block currentBlock = world.func_180495_p(new BlockPos(player.field_70165_t, blockY, player.field_70161_v)).func_177230_c();
                        if (currentBlock == Blocks.field_150353_l || currentBlock == Blocks.field_150480_ab || currentBlock == Blocks.field_150470_am || currentBlock == Blocks.field_189877_df) {
                            player.field_70181_x += MathHelper.func_151237_a((double)0.07, (double)Double.MIN_VALUE, (double)0.1);
                        } else if (currentBlock != Blocks.field_150350_a) continue block0;
                        blockY -= 1.0;
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @SideOnly(value=Side.CLIENT)
    public static void onFOVChange(FOVUpdateEvent event) {
        if (!SizeUtils.isSizeComponentEnabled) {
            return;
        }
        if (event.getEntity() != null) {
            EntityPlayer player = event.getEntity();
            PotionEffect speed = player.func_70660_b(MobEffects.field_76424_c);
            float fovScale = event.getFov() / event.getNewfov();
            if (player.func_70051_ag()) {
                event.setNewfov(speed != null ? fovScale + (0.1f * (float)(speed.func_76458_c() + 1) + 0.15f) : fovScale + 0.1f);
            } else {
                event.setNewfov(speed != null ? fovScale + 0.1f * (float)(speed.func_76458_c() + 1) : fovScale);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        if (!SizeUtils.isSizeComponentEnabled) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        float scale = player.field_70131_O / 1.8f;
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 1 && player.field_70131_O > 1.8f) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-scale * 2.0f));
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 2 && player.field_70131_O > 1.8f) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(scale * 2.0f));
        }
    }
}

