/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.events;

import com.github.sokyranthedragon.mia.config.GenericAdditionsConfig;
import com.github.sokyranthedragon.mia.core.MiaBlocks;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class WorldEvents {
    @SubscribeEvent
    public static void onWorldDecoration(DecorateBiomeEvent.Decorate event) {
        World world = event.getWorld();
        if (event.getType() != DecorateBiomeEvent.Decorate.EventType.DEAD_BUSH) {
            return;
        }
        if (MiaBlocks.flowerDead == null) {
            return;
        }
        if (world.field_73011_w.func_186058_p() != DimensionType.OVERWORLD) {
            return;
        }
        if (event.getResult() != Event.Result.ALLOW && event.getResult() != Event.Result.DEFAULT) {
            return;
        }
        BlockPos pos = event.getPlacementPos() != null ? event.getPlacementPos() : event.getChunkPos().func_180331_a(0, 0, 0);
        Biome biome = world.getBiomeForCoordsBody(pos);
        Set biomeTypes = BiomeDictionary.getTypes((Biome)biome);
        if (world.func_175624_G() != WorldType.field_77138_c && (biomeTypes.contains(BiomeDictionary.Type.SANDY) || biomeTypes.contains(BiomeDictionary.Type.DRY) || biomeTypes.contains(BiomeDictionary.Type.DEAD) || biomeTypes.contains(BiomeDictionary.Type.WASTELAND))) {
            int max = biome.func_185353_n() >= 1.0f ? world.field_73012_v.nextInt(6) : world.field_73012_v.nextInt(4);
            for (int i = 0; i < max; ++i) {
                int xPos = pos.func_177958_n() + world.field_73012_v.nextInt(16);
                int zPos = pos.func_177952_p() + world.field_73012_v.nextInt(16);
                WorldEvents.generate(world, biome, new BlockPos(xPos, 0, zPos));
            }
        }
    }

    private static void generate(World world, Biome biome, BlockPos pos) {
        assert (MiaBlocks.flowerDead != null);
        if ((pos = WorldEvents.findGround(world, pos)) != null && pos.func_177956_o() >= 1) {
            float temperature = Math.max(0.1f, biome.func_180626_a(pos));
            if ((double)world.field_73012_v.nextInt() <= GenericAdditionsConfig.evtp.deadFlowerSpawnChance * (double)temperature) {
                world.func_180501_a(pos, MiaBlocks.flowerDead.func_176223_P(), 2);
            }
        }
    }

    @Nullable
    private static BlockPos findGround(World world, BlockPos pos) {
        assert (MiaBlocks.flowerDead != null);
        pos = world.func_175672_r(pos);
        while (pos.func_177956_o() >= 55) {
            IBlockState stateDown = world.func_180495_p(pos);
            if (stateDown.func_185914_p() && !(stateDown.func_177230_c() instanceof BlockLeaves)) {
                if (MiaBlocks.flowerDead.canSustainPlant(stateDown, (IBlockAccess)world, pos, EnumFacing.DOWN, (IPlantable)MiaBlocks.flowerDead)) {
                    BlockPos up = pos.func_177984_a();
                    if (world.func_180495_p(up).func_177230_c() instanceof BlockLeaves) {
                        return null;
                    }
                    return up;
                }
                return null;
            }
            pos = pos.func_177977_b();
        }
        return null;
    }
}

