/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.gui;

import com.github.sokyranthedragon.mia.capabilities.MusicPlayerCapabilityProvider;
import com.github.sokyranthedragon.mia.gui.client.GuiEggSorter;
import com.github.sokyranthedragon.mia.gui.client.GuiMusicPlayer;
import com.github.sokyranthedragon.mia.gui.client.GuiPixieDustExtractor;
import com.github.sokyranthedragon.mia.gui.client.GuiVoidCreator;
import com.github.sokyranthedragon.mia.gui.container.ContainerEggSorter;
import com.github.sokyranthedragon.mia.gui.container.ContainerMusicPlayer;
import com.github.sokyranthedragon.mia.gui.container.ContainerPixieDustExtractor;
import com.github.sokyranthedragon.mia.gui.container.ContainerVoidCreator;
import com.github.sokyranthedragon.mia.handlers.MusicPlayerStackHandler;
import com.github.sokyranthedragon.mia.inventory.MusicPlayerInventory;
import com.github.sokyranthedragon.mia.tile.TileEggSorter;
import com.github.sokyranthedragon.mia.tile.TilePixieDustExtractor;
import com.github.sokyranthedragon.mia.tile.TileVoidCreator;
import com.github.sokyranthedragon.mia.utilities.InventoryUtils;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;

public class GuiHandler
implements IGuiHandler {
    public static final int EGG_SORTER = 0;
    public static final int VOID_CREATOR = 1;
    public static final int PIXIE_DUST_EXTRACTOR = 2;
    public static final int MUSIC_PLAYER = 3;

    @Nullable
    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tile = null;
        if (id != 3) {
            tile = world.func_175625_s(new BlockPos(x, y, z));
        }
        switch (id) {
            case 0: {
                if (!(tile instanceof TileEggSorter)) break;
                return new ContainerEggSorter(player.field_71071_by, (IInventory)((TileEggSorter)tile));
            }
            case 1: {
                if (!(tile instanceof TileVoidCreator)) break;
                return new ContainerVoidCreator(player.field_71071_by, (TileVoidCreator)tile);
            }
            case 2: {
                if (!(tile instanceof TilePixieDustExtractor)) break;
                return new ContainerPixieDustExtractor(player.field_71071_by, (IInventory)((TilePixieDustExtractor)tile));
            }
            case 3: {
                ItemStack musicPlayer = InventoryUtils.getItemFromPlayer(player, x, y);
                MusicPlayerStackHandler capability = (MusicPlayerStackHandler)musicPlayer.getCapability(MusicPlayerCapabilityProvider.ITEM_HANDLER_CAPABILITY, null);
                if (!(capability instanceof MusicPlayerStackHandler)) break;
                return new ContainerMusicPlayer(player.field_71071_by, new MusicPlayerInventory(musicPlayer, capability));
            }
        }
        return null;
    }

    @Nullable
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tile = null;
        if (id != 3) {
            tile = world.func_175625_s(new BlockPos(x, y, z));
        }
        switch (id) {
            case 0: {
                if (!(tile instanceof TileEggSorter)) break;
                return new GuiEggSorter(player.field_71071_by, (IInventory)((TileEggSorter)tile));
            }
            case 1: {
                if (!(tile instanceof TileVoidCreator)) break;
                return new GuiVoidCreator(player.field_71071_by, (TileVoidCreator)tile);
            }
            case 2: {
                if (!(tile instanceof TilePixieDustExtractor)) break;
                return new GuiPixieDustExtractor(player.field_71071_by, (IInventory)((TilePixieDustExtractor)tile));
            }
            case 3: {
                ItemStack musicPlayer = InventoryUtils.getItemFromPlayer(player, x, y);
                MusicPlayerStackHandler capability = (MusicPlayerStackHandler)musicPlayer.getCapability(MusicPlayerCapabilityProvider.ITEM_HANDLER_CAPABILITY, null);
                if (!(capability instanceof MusicPlayerStackHandler)) break;
                return new GuiMusicPlayer(player.field_71071_by, new MusicPlayerInventory(musicPlayer, capability));
            }
        }
        return null;
    }
}

