/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.charm;

import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.dungeontactics.DungeonTactics;
import com.github.sokyranthedragon.mia.integrations.dungeontactics.IDungeonTacticsIntegration;
import com.github.sokyranthedragon.mia.utilities.LootUtils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.world.storage.loot.functions.LootFunction;
import org.jetbrains.annotations.NotNull;
import svenhjol.charm.Charm;
import svenhjol.charm.brewing.block.BlockFlavoredCake;
import svenhjol.charm.brewing.feature.FlavoredCake;
import svenhjol.charm.crafting.feature.SuspiciousSoup;
import svenhjol.charm.tweaks.feature.ExtraRecords;
import svenhjol.charm.tweaks.item.CharmItemRecord;

class DungeonTacticsCharmIntegration
implements IDungeonTacticsIntegration {
    DungeonTacticsCharmIntegration() {
    }

    @Override
    @Nullable
    public DungeonTactics.ILootBagListener registerLootBagListener() {
        return (type, loot) -> {
            switch (type) {
                case FOOD: {
                    if (Charm.hasFeature(SuspiciousSoup.class)) {
                        LootUtils.addDtLoot(loot, SuspiciousSoup.suspiciousSoup, LootUtils.setMetadataFunction(0, SuspiciousSoup.maxTypes - 1));
                    }
                    if (!Charm.hasFeature(FlavoredCake.class)) break;
                    for (BlockFlavoredCake cake : FlavoredCake.cakes.values()) {
                        LootUtils.addDtLoot(loot, (Block)cake, 1, new LootFunction[0]);
                    }
                    break;
                }
                case RECORD: {
                    if (!Charm.hasFeature(ExtraRecords.class)) break;
                    for (CharmItemRecord record : ExtraRecords.records) {
                        LootUtils.addDtLoot(loot, (Item)record, new LootFunction[0]);
                    }
                    break;
                }
            }
        };
    }

    @Override
    @NotNull
    public ModIds getModId() {
        return ModIds.CHARM;
    }
}

