/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.chisel;

import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.config.ChiselConfiguration;
import com.github.sokyranthedragon.mia.config.MiaConfig;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.base.IBaseMod;
import com.github.sokyranthedragon.mia.integrations.base.IModIntegration;
import com.github.sokyranthedragon.mia.integrations.chisel.IChiselIntegration;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import org.apache.logging.log4j.util.TriConsumer;

public class Chisel
implements IBaseMod {
    private final Map<ModIds, IChiselIntegration> modIntegrations = new HashMap<ModIds, IChiselIntegration>();

    @Override
    public void addIntegration(IModIntegration integration) {
        if (!ChiselConfiguration.externalIntegrationsEnabled) {
            return;
        }
        if (integration instanceof IChiselIntegration) {
            this.modIntegrations.put(integration.getModId(), (IChiselIntegration)integration);
        } else {
            Mia.LOGGER.warn("Incorrect Chisel integration with id of " + (Object)((Object)integration.getModId()) + ": " + integration.toString());
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (!this.modIntegrations.isEmpty() && !MiaConfig.disableAllRecipes) {
            ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Chisel addRecipes", (int)this.modIntegrations.size());
            for (IChiselIntegration integration : this.modIntegrations.values()) {
                progressBar.step(integration.getModId().modId);
                integration.sendChiselMessages(Chisel::sendChiselMessage, (TriConsumer<String, Block, Integer>)((TriConsumer)Chisel::sendChiselMessage));
            }
            ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        }
    }

    public static void sendChiselMessage(String blockType, Block block, int meta) {
        Chisel.sendChiselMessage(blockType, new ItemStack(block, 1, meta));
    }

    public static void sendChiselMessage(String blockType, ItemStack[] items) {
        for (ItemStack item : items) {
            Chisel.sendChiselMessage(blockType, item);
        }
    }

    public static void sendChiselMessage(String blockType, ItemStack item) {
        Block block = Block.func_149634_a((Item)item.func_77973_b());
        if (block != Blocks.field_150350_a && block.getRegistryName() != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("group", blockType);
            nbt.func_74782_a("stack", (NBTBase)item.func_77955_b(new NBTTagCompound()));
            nbt.func_74778_a("block", block.getRegistryName().toString());
            nbt.func_74768_a("meta", item.func_77960_j());
            FMLInterModComms.sendMessage((String)ModIds.CHISEL.modId, (String)"add_variation", (NBTTagCompound)nbt);
        }
    }
}

