/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.ender_io_zoo;

import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.jer.IJerIntegration;
import com.github.sokyranthedragon.mia.integrations.jer.JustEnoughResources;
import crazypants.enderio.zoo.entity.EntityConcussionCreeper;
import crazypants.enderio.zoo.entity.EntityDireWolf;
import crazypants.enderio.zoo.entity.EntityEnderminy;
import crazypants.enderio.zoo.entity.EntityEpicSquid;
import crazypants.enderio.zoo.entity.EntityFallenKnight;
import crazypants.enderio.zoo.entity.EntityFallenMount;
import crazypants.enderio.zoo.entity.EntityLoveChild;
import crazypants.enderio.zoo.entity.EntityOwl;
import crazypants.enderio.zoo.entity.EntityWitherCat;
import crazypants.enderio.zoo.entity.EntityWitherWitch;
import crazypants.enderio.zoo.spawn.IBiomeFilter;
import crazypants.enderio.zoo.spawn.ISpawnEntry;
import crazypants.enderio.zoo.spawn.MobSpawns;
import crazypants.enderio.zoo.spawn.SpawnConfig;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import jeresources.api.IMobRegistry;
import jeresources.api.conditionals.LightLevel;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
class JerEnderIoZooIntegration
implements IJerIntegration {
    private Collection<? extends ISpawnEntry> entries;

    JerEnderIoZooIntegration() {
    }

    @Override
    public void addMobs(JustEnoughResources.CustomMobTableBuilder builder) {
        this.entries = MobSpawns.instance.getEntries();
        if (this.entries == null || this.entries.isEmpty()) {
            this.entries = SpawnConfig.loadSpawnConfig();
        }
        builder.add(ModIds.ENDER_IO.loadSimple("concussioncreeper"), EntityConcussionCreeper.class);
        builder.add(ModIds.ENDER_IO.loadSimple("direwolf"), EntityDireWolf.class);
        builder.add(ModIds.ENDER_IO.loadSimple("enderminy"), EntityEnderminy.class);
        builder.add(ModIds.ENDER_IO.loadSimple("epicsquid"), EntityEpicSquid.class);
        builder.add(ModIds.ENDER_IO.loadSimple("fallenknight"), EntityFallenKnight.class);
        builder.add(ModIds.ENDER_IO.loadSimple("fallenmount"), EntityFallenMount.class);
        builder.add(ModIds.ENDER_IO.loadSimple("lovechild"), EntityLoveChild.class);
        builder.add(ModIds.ENDER_IO.loadSimple("owl"), EntityOwl.class);
        builder.add(ModIds.ENDER_IO.loadSimple("withercat"), EntityWitherCat.class);
        builder.add(ModIds.ENDER_IO.loadSimple("witherwitch"), EntityWitherWitch.class);
    }

    @Override
    public void configureMob(ResourceLocation resource, EntityLivingBase entity, @Nullable LootTableManager manager, IMobRegistry mobRegistry) {
        ISpawnEntry iSpawnEntry;
        EntityEntry entry = EntityRegistry.getEntry(entity.getClass());
        HashSet<Biome> biomes = null;
        if (entry != null && entry.getRegistryName() != null && (iSpawnEntry = (ISpawnEntry)this.entries.stream().filter(e -> e.getMobName().equals(entry.getRegistryName().toString())).findFirst().orElse(null)) != null) {
            biomes = new HashSet<Biome>();
            for (IBiomeFilter filter : iSpawnEntry.getFilters()) {
                biomes.addAll(Arrays.asList(filter.getMatchedBiomes()));
            }
        }
        if (biomes == null || biomes.isEmpty()) {
            mobRegistry.register(entity, LightLevel.hostile, 5, resource);
        } else {
            mobRegistry.register(entity, LightLevel.any, 5, (String[])biomes.stream().map(Biome::func_185359_l).toArray(String[]::new), resource);
        }
    }

    @Override
    public ModIds getModId() {
        return ModIds.ENDER_IO_ZOO;
    }
}

