/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.extrabotany;

import com.github.sokyranthedragon.mia.config.ExtraBotanyConfig;
import com.github.sokyranthedragon.mia.dispenserbehavior.DispenserLootBag;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.base.IBaseMod;
import com.github.sokyranthedragon.mia.integrations.base.IModIntegration;
import com.github.sokyranthedragon.mia.integrations.extrabotany.DungeonTacticsExtraBotanyIntegration;
import com.github.sokyranthedragon.mia.integrations.extrabotany.HatcheryExtraBotanyIntegration;
import com.github.sokyranthedragon.mia.integrations.extrabotany.JeiExtraBotany;
import com.github.sokyranthedragon.mia.integrations.extrabotany.JerExtraBotanyIntegration;
import com.github.sokyranthedragon.mia.integrations.extrabotany.ThermalExpansionExtraBotanyIntegration;
import com.meteor.extrabotany.common.item.ModItems;
import com.meteor.extrabotany.common.item.bonus.ItemBonusBase;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.oredict.OreIngredient;

public class ExtraBotany
implements IBaseMod {
    @Override
    public void register(BiConsumer<ModIds, IModIntegration> modIntegration) {
        if (ModIds.JEI.isLoaded) {
            modIntegration.accept(ModIds.JEI, new JeiExtraBotany());
        }
        if (ExtraBotanyConfig.enableDungeonTacticsIntegration && ModIds.DUNGEON_TACTICS.isLoaded) {
            modIntegration.accept(ModIds.DUNGEON_TACTICS, new DungeonTacticsExtraBotanyIntegration());
        }
        if (ExtraBotanyConfig.enableTeIntegration && ModIds.THERMAL_EXPANSION.isLoaded) {
            modIntegration.accept(ModIds.THERMAL_EXPANSION, new ThermalExpansionExtraBotanyIntegration());
        }
        if (ModIds.JER.isLoaded) {
            modIntegration.accept(ModIds.JER, new JerExtraBotanyIntegration());
        }
        if (ModIds.EXTRABOTANY.isLoaded) {
            modIntegration.accept(ModIds.EXTRABOTANY, new HatcheryExtraBotanyIntegration(ExtraBotanyConfig.enableHatcheryIntegration));
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
    }

    @Override
    public void registerDispenserBehaviors() {
        DispenserLootBag.getInstance().addListener((source, stack) -> {
            if (!(stack.func_77973_b() instanceof ItemBonusBase)) {
                return false;
            }
            ItemBonusBase item = (ItemBonusBase)stack.func_77973_b();
            List loot = item.getWeightCategory(stack);
            if (loot == null || loot.isEmpty()) {
                return false;
            }
            ((IBehaviorDispenseItem)BlockDispenser.field_149943_a.func_82594_a(null)).func_82482_a(source, item.rollItem(stack, null, loot));
            stack.func_190918_g(1);
            return true;
        }, ModItems.rewardbag, ModItems.rewardbag943, ModItems.candybag);
    }

    private static void replaceItemIngredient(NonNullList<Ingredient> ingredients, ItemStack toReplace, String oredictReplacement) {
        ExtraBotany.replaceItemIngredient(ingredients, toReplace, oredictReplacement, true);
    }

    private static void replaceItemIngredient(NonNullList<Ingredient> ingredients, ItemStack toReplace, String oredictReplacement, boolean shortCircuitOnSuccess) {
        for (int i = 0; i < ingredients.size(); ++i) {
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            if (!ingredient.apply(toReplace)) continue;
            ingredients.set(i, (Object)new OreIngredient(oredictReplacement));
            if (!shortCircuitOnSuccess) continue;
            return;
        }
    }
}

