/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.extrabotany;

import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.jei.IJeiIntegration;
import com.github.sokyranthedragon.mia.integrations.jei.categories.lootbag.LootBagCategory;
import com.github.sokyranthedragon.mia.integrations.jei.categories.lootbag.LootBagEntry;
import com.github.sokyranthedragon.mia.integrations.jei.categories.lootbag.LootBagRegistry;
import com.github.sokyranthedragon.mia.integrations.jei.categories.lootbag.LootBagWrapper;
import com.meteor.extrabotany.api.item.WeightCategory;
import com.meteor.extrabotany.common.item.ModItems;
import com.meteor.extrabotany.common.item.bonus.ItemBonusBase;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.item.ItemStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
class JeiExtraBotany
implements IJeiIntegration {
    JeiExtraBotany() {
    }

    @Override
    public void register(IModRegistry registry, Collection<String> registeredCategories) {
        if (registeredCategories.add("mia.loot_bag")) {
            registry.handleRecipes(LootBagEntry.class, LootBagWrapper::new, "mia.loot_bag");
            registry.addRecipes(LootBagRegistry.getRecipesOrEmpty(), "mia.loot_bag");
        }
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.rewardbag, 1, 0), new String[]{"mia.loot_bag"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.rewardbag, 1, 1), new String[]{"mia.loot_bag"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.rewardbag, 1, 2), new String[]{"mia.loot_bag"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.rewardbag, 1, 3), new String[]{"mia.loot_bag"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.rewardbag943), new String[]{"mia.loot_bag"});
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.candybag), new String[]{"mia.loot_bag"});
    }

    @Override
    public void registerCategories(IRecipeCategoryRegistration registry, Collection<String> registeredCategories) {
        if (registeredCategories.add("mia.loot_bag")) {
            registry.addRecipeCategories(new IRecipeCategory[]{new LootBagCategory(registry.getJeiHelpers().getGuiHelper(), ModItems.rewardbag)});
        }
    }

    @Override
    public void registerRecipes() {
        LootBagRegistry lootBagRegistry = LootBagRegistry.getInstance();
        if (lootBagRegistry != null) {
            this.registerLootBag(lootBagRegistry, new ItemStack(ModItems.rewardbag, 1, 0));
            this.registerLootBag(lootBagRegistry, new ItemStack(ModItems.rewardbag, 1, 1));
            this.registerLootBag(lootBagRegistry, new ItemStack(ModItems.rewardbag, 1, 2));
            this.registerLootBag(lootBagRegistry, new ItemStack(ModItems.rewardbag, 1, 3));
            this.registerLootBag(lootBagRegistry, new ItemStack(ModItems.rewardbag943));
            this.registerLootBag(lootBagRegistry, new ItemStack(ModItems.candybag));
        } else if (ModIds.JER.isLoaded) {
            Mia.LOGGER.error("Could not access Loot Bag recipe registry, this shouldn't have happened as Dungeon Tactics and JER are loaded. Something is very wrong.");
        }
    }

    @Override
    public ModIds getModId() {
        return ModIds.EXTRABOTANY;
    }

    private void registerLootBag(LootBagRegistry registry, ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ItemBonusBase)) {
            Mia.LOGGER.error("Tried to register incorrect ExtraBotany loot bag:\n" + stack.toString());
            return;
        }
        ItemBonusBase item = (ItemBonusBase)stack.func_77973_b();
        List possibleOutputs = item.getWeightCategory(stack);
        float totalWeight = possibleOutputs.stream().mapToInt(WeightCategory::getWeight).sum();
        Set<LootBagEntry.BagOutputEntry> bagOutputs = possibleOutputs.stream().map(entry -> new LootBagEntry.BagOutputEntry(Collections.singletonList(entry.getCategory()), (float)entry.getWeight().intValue() / totalWeight * 100.0f)).collect(Collectors.toSet());
        List<LootBagEntry> entries = LootBagEntry.getEntries(stack, bagOutputs);
        for (LootBagEntry entry2 : entries) {
            registry.registerLootBagRecipe(entry2);
        }
    }
}

