/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.futuremc;

import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.config.FutureMcConfiguration;
import com.github.sokyranthedragon.mia.config.MiaConfig;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.base.IBaseMod;
import com.github.sokyranthedragon.mia.integrations.base.IModIntegration;
import com.github.sokyranthedragon.mia.integrations.futuremc.DungeonTacticsFutureMcIntegration;
import com.github.sokyranthedragon.mia.integrations.futuremc.ExtraUtilsFutureMcIntegration;
import com.github.sokyranthedragon.mia.integrations.futuremc.HarvestcraftFutureMcIntegration;
import com.github.sokyranthedragon.mia.integrations.futuremc.HatcheryFutureMcIntegration;
import com.github.sokyranthedragon.mia.integrations.futuremc.IFutureMcIntegration;
import com.github.sokyranthedragon.mia.integrations.futuremc.IndustrialForegoingFutureMcIntegration;
import com.github.sokyranthedragon.mia.integrations.futuremc.JerFutureMcIntegration;
import com.github.sokyranthedragon.mia.integrations.futuremc.QuarkFutureMcIntegration;
import com.github.sokyranthedragon.mia.integrations.futuremc.TConstructFutureMcIntegration;
import com.github.sokyranthedragon.mia.integrations.futuremc.ThermalExpansionFutureMcIntegration;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.oredict.OreDictionary;
import thedarkcolour.futuremc.api.BeePollinationHandler;
import thedarkcolour.futuremc.api.BeePollinationTargetsJVM;
import thedarkcolour.futuremc.entity.bee.EntityBee;
import thedarkcolour.futuremc.recipe.campfire.CampfireRecipes;
import thedarkcolour.futuremc.recipe.furnace.BlastFurnaceRecipes;
import thedarkcolour.futuremc.recipe.furnace.SmokerRecipes;
import thedarkcolour.futuremc.recipe.stonecutter.StonecutterRecipes;
import thedarkcolour.futuremc.registry.FBlocks;
import thedarkcolour.futuremc.registry.FItems;

public class FutureMc
implements IBaseMod {
    private final List<IFutureMcIntegration> modIntegrations = new LinkedList<IFutureMcIntegration>();

    @Override
    public void register(BiConsumer<ModIds, IModIntegration> modIntegration) {
        if (ModIds.JER.isLoaded) {
            modIntegration.accept(ModIds.JER, new JerFutureMcIntegration());
        }
        if (FutureMcConfiguration.enableQuarkIntegration && ModIds.QUARK.isLoaded) {
            modIntegration.accept(ModIds.QUARK, new QuarkFutureMcIntegration());
        }
        if (FutureMcConfiguration.enableTeIntegration && ModIds.THERMAL_EXPANSION.isLoaded) {
            modIntegration.accept(ModIds.THERMAL_EXPANSION, new ThermalExpansionFutureMcIntegration());
        }
        if (ModIds.HATCHERY.isLoaded) {
            modIntegration.accept(ModIds.HATCHERY, new HatcheryFutureMcIntegration(FutureMcConfiguration.enableHatcheryIntegration));
        }
        if (FutureMcConfiguration.enableHarvestcraftIntegration && ModIds.HARVESTCRAFT.isLoaded) {
            modIntegration.accept(ModIds.HARVESTCRAFT, new HarvestcraftFutureMcIntegration());
        }
        if (FutureMcConfiguration.enableIFIntegration && ModIds.INDUSTRIAL_FOREGOING.isLoaded) {
            modIntegration.accept(ModIds.INDUSTRIAL_FOREGOING, new IndustrialForegoingFutureMcIntegration());
        }
        if (FutureMcConfiguration.enableDungeonTacticsIntegration && ModIds.DUNGEON_TACTICS.isLoaded) {
            modIntegration.accept(ModIds.DUNGEON_TACTICS, new DungeonTacticsFutureMcIntegration());
        }
        if (FutureMcConfiguration.enableXu2Integration && ModIds.EXTRA_UTILITIES.isLoaded) {
            modIntegration.accept(ModIds.EXTRA_UTILITIES, new ExtraUtilsFutureMcIntegration());
        }
        if (FutureMcConfiguration.enableTConstructIntegration && ModIds.TINKERS_CONSTRUCT.isLoaded) {
            modIntegration.accept(ModIds.TINKERS_CONSTRUCT, new TConstructFutureMcIntegration());
        }
    }

    @Override
    public void addIntegration(IModIntegration integration) {
        if (!FutureMcConfiguration.externalIntegrationsEnabled) {
            return;
        }
        if (integration instanceof IFutureMcIntegration) {
            this.modIntegrations.add((IFutureMcIntegration)integration);
        } else {
            Mia.LOGGER.warn("Incorrect FutureMC integration with id of " + (Object)((Object)integration.getModId()) + ": " + integration.toString());
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (FutureMcConfiguration.futureMcAdditionsEnabled && !MiaConfig.disableOreDict) {
            OreDictionary.registerOre((String)"blockHoney", (Block)FBlocks.INSTANCE.getHONEY_BLOCK());
            OreDictionary.registerOre((String)"honeycomb", (Item)FItems.INSTANCE.getHONEYCOMB());
            OreDictionary.registerOre((String)"listAllsugar", (Item)FItems.INSTANCE.getHONEY_BOTTLE());
            OreDictionary.registerOre((String)"dropHoney", (Item)FItems.INSTANCE.getHONEY_BOTTLE());
            OreDictionary.registerOre((String)"foodHoneydrop", (Item)FItems.INSTANCE.getHONEY_BOTTLE());
        }
        if (!this.modIntegrations.isEmpty() && !MiaConfig.disableAllRecipes) {
            ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"FutureMc addRecipes", (int)this.modIntegrations.size());
            for (IFutureMcIntegration integration : this.modIntegrations) {
                progressBar.step(integration.getModId().modId);
                integration.addRecipes();
                IBlockState[] flowersToRegister = integration.registerPollinationFlowers();
                if (flowersToRegister.length <= 0) continue;
                BeePollinationTargetsJVM.addPollinationTargets((IBlockState[])new IBlockState[0]);
            }
            ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        }
    }

    public static void addFoodRecipe(ItemStack input, ItemStack output, int duration) {
        FutureMc.addCampfireRecipe(input, output, duration);
        FutureMc.addSmokerRecipe(input, output);
    }

    public static void addFoodRecipe(ItemStack input, ItemStack output) {
        FutureMc.addFoodRecipe(input, output, 600);
    }

    public static void oreDictBlastFurnaceRecipe(ItemStack input, int count, String ... outputs) {
        if (BlastFurnaceRecipes.INSTANCE.getRecipe(input) != null) {
            Mia.LOGGER.warn("Tried to add existing FutureMc blast furnace oredict recipe, input: " + input.toString());
            return;
        }
        for (String output : outputs) {
            NonNullList ores = OreDictionary.getOres((String)output);
            if (ores.isEmpty()) continue;
            ItemStack ore = (ItemStack)ores.get(0);
            BlastFurnaceRecipes.INSTANCE.addRecipe(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{input}), new ItemStack(ore.func_77973_b(), count, ore.func_77960_j()));
            return;
        }
    }

    public static void oreDictBlastFurnaceRecipe(ItemStack input, String ... outputs) {
        FutureMc.oreDictBlastFurnaceRecipe(input, 1, outputs);
    }

    public static void oreDictBlastFurnaceRecipe(Item input, int meta, int count, String ... outputs) {
        FutureMc.oreDictBlastFurnaceRecipe(new ItemStack(input, 1, meta), count, outputs);
    }

    public static void oreDictBlastFurnaceRecipe(Item input, String ... outputs) {
        FutureMc.oreDictBlastFurnaceRecipe(new ItemStack(input), outputs);
    }

    public static void addBlastFurnaceRecipe(ItemStack input, ItemStack output) {
        if (BlastFurnaceRecipes.INSTANCE.getRecipe(input) == null) {
            BlastFurnaceRecipes.INSTANCE.addRecipe(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{input}), output);
        } else {
            Mia.LOGGER.warn("Tried to add existing FutureMc blast furnace recipe, input: " + input.toString() + " output: " + output.toString());
        }
    }

    public static void addSmokerRecipe(ItemStack input, ItemStack output) {
        if (SmokerRecipes.INSTANCE.getRecipe(input) == null) {
            SmokerRecipes.INSTANCE.addRecipe(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{input}), output);
        } else {
            Mia.LOGGER.warn("Tried to add existing FutureMc smoker recipe, input: " + input.toString() + " output: " + output.toString());
        }
    }

    public static void addStonecutterRecipes(ItemStack input, ItemStack ... output) {
        if (output.length == 0) {
            return;
        }
        List recipes = StonecutterRecipes.INSTANCE.getRecipes(input);
        for (ItemStack item : output) {
            if (recipes.stream().noneMatch(existing -> existing.getOutput().func_185136_b(input))) {
                StonecutterRecipes.INSTANCE.addRecipe(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{input}), item);
                continue;
            }
            Mia.LOGGER.warn("Tried to add existing FutureMc stonecutter recipe, input: " + input.toString() + " output: " + item.toString());
        }
    }

    public static void addCampfireRecipe(ItemStack input, ItemStack output, int duration) {
        if (CampfireRecipes.INSTANCE.getRecipe(input) == null) {
            CampfireRecipes.INSTANCE.addRecipe(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{input}), output, duration);
        } else {
            Mia.LOGGER.warn("Tried to add existing FutureMc campfire recipe, input: " + input.toString() + " output: " + output.toString());
        }
    }

    public static void addCampfireRecipe(ItemStack input, ItemStack output) {
        FutureMc.addCampfireRecipe(input, output, 600);
    }

    @ParametersAreNonnullByDefault
    public static class GenericBeePollinationHandler
    implements BeePollinationHandler {
        private final PropertyInteger ageProperty;
        private final int maxValue;

        public GenericBeePollinationHandler(PropertyInteger ageProperty) {
            this(ageProperty, ageProperty.func_177700_c().stream().max(Integer::compare).orElse(Integer.MIN_VALUE));
        }

        public GenericBeePollinationHandler(PropertyInteger ageProperty, int maxValue) {
            this.ageProperty = ageProperty;
            this.maxValue = maxValue;
        }

        public boolean pollinateCrop(World world, BlockPos blockPos, IBlockState blockState, EntityBee entityBee) {
            if ((Integer)world.func_180495_p(blockPos).func_177229_b((IProperty)this.ageProperty) < this.maxValue) {
                entityBee.field_70170_p.func_175718_b(2005, blockPos, 0);
                entityBee.field_70170_p.func_175656_a(blockPos, blockState.func_177226_a((IProperty)this.ageProperty, (Comparable)Integer.valueOf((Integer)blockState.func_177229_b((IProperty)this.ageProperty) + 1)));
                return true;
            }
            return false;
        }
    }
}

