/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.harvestcraft;

import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.utilities.ItemStackUtils;
import com.pam.harvestcraft.item.GrinderRecipes;
import com.pam.harvestcraft.item.ItemRegistry;
import com.pam.harvestcraft.item.PresserRecipes;
import com.pam.harvestcraft.item.WaterFilterRecipes;
import com.pam.harvestcraft.tileentities.MarketData;
import com.pam.harvestcraft.tileentities.MarketItems;
import com.pam.harvestcraft.tileentities.ShippingBinData;
import com.pam.harvestcraft.tileentities.ShippingBinItems;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class HarvestcraftRecipes {
    @Nullable
    public static final Collection<MarketData> marketRecipes;
    @Nullable
    public static final Collection<ShippingBinData> shippingRecipes;
    @Nullable
    public static final Map<ItemStack, ItemStack[]> pressingRecipes;
    @Nullable
    public static final Map<ItemStack, ItemStack[]> grindingRecipes;
    @Nullable
    public static final Map<ItemStack, ItemStack[]> waterFilterRecipes;

    private HarvestcraftRecipes() {
    }

    public static void addMarketRecipe(ItemStack item, int price) {
        HarvestcraftRecipes.addMarketRecipe(item, new ItemStack(Items.field_151166_bC), price);
    }

    public static void addMarketRecipe(ItemStack item, ItemStack currency) {
        HarvestcraftRecipes.addMarketRecipe(item, currency, 1);
    }

    public static void addMarketRecipe(ItemStack item, ItemStack currency, int price) {
        if (marketRecipes != null && !HarvestcraftRecipes.doesMarketRecipeExist(item, currency)) {
            marketRecipes.add(new MarketData(item, currency, price));
        }
    }

    public static void addShippingRecipe(ItemStack item, int price) {
        HarvestcraftRecipes.addShippingRecipe(item, new ItemStack(Items.field_151166_bC), price);
    }

    public static void addShippingRecipe(ItemStack item, ItemStack currency) {
        HarvestcraftRecipes.addShippingRecipe(item, currency, 1);
    }

    public static void addShippingRecipe(ItemStack item, ItemStack currency, int price) {
        if (shippingRecipes != null && !HarvestcraftRecipes.doesShippingRecipeExist(item, currency)) {
            shippingRecipes.add(new ShippingBinData(item, currency, price));
        }
    }

    public static void addPressingRecipe(ItemStack input, ItemStack outputFirst) {
        HarvestcraftRecipes.addPressingRecipe(input, outputFirst, ItemStack.field_190927_a);
    }

    public static void addPressingRecipe(ItemStack input, ItemStack outputFirst, ItemStack outputSecond) {
        if (pressingRecipes != null && !HarvestcraftRecipes.doesPressingRecipeExist(input)) {
            pressingRecipes.put(input, new ItemStack[]{outputFirst, outputSecond});
        }
    }

    public static void addGrindingRecipe(ItemStack input, ItemStack outputFirst) {
        HarvestcraftRecipes.addGrindingRecipe(input, outputFirst, ItemStack.field_190927_a);
    }

    public static void addGrindingRecipe(ItemStack input, ItemStack outputFirst, ItemStack outputSecond) {
        if (grindingRecipes != null && !HarvestcraftRecipes.doesGrindingRecipeExist(input)) {
            grindingRecipes.put(input, new ItemStack[]{outputFirst, outputSecond});
        }
    }

    public static void addFilteringRecipe(ItemStack input, ItemStack outputFirst) {
        HarvestcraftRecipes.addFilteringRecipe(input, outputFirst, ItemStack.field_190927_a);
    }

    public static void addFilteringRecipe(ItemStack input, ItemStack outputFirst, ItemStack outputSecond) {
        if (waterFilterRecipes != null && !HarvestcraftRecipes.doesFilteringRecipeExist(input)) {
            waterFilterRecipes.put(input, new ItemStack[]{outputFirst, outputSecond});
        }
    }

    public static boolean doesMarketRecipeExist(ItemStack item, ItemStack currency) {
        return marketRecipes == null || marketRecipes.stream().anyMatch(entry -> ItemStackUtils.areItemStackEqualIgnoreCount(entry.getItem(), item) && ItemStackUtils.areItemStackEqualIgnoreCount(entry.getCurrency(), currency));
    }

    public static boolean doesShippingRecipeExist(ItemStack item, ItemStack currency) {
        return shippingRecipes == null || shippingRecipes.stream().anyMatch(entry -> ItemStackUtils.areItemStackEqualIgnoreCount(entry.getItem(), item) && ItemStackUtils.areItemStackEqualIgnoreCount(entry.getCurrency(), currency));
    }

    public static boolean doesPressingRecipeExist(ItemStack input) {
        return pressingRecipes == null || pressingRecipes.keySet().stream().anyMatch(entry -> HarvestcraftRecipes.isSameItem(entry, input));
    }

    public static boolean doesGrindingRecipeExist(ItemStack input) {
        return grindingRecipes == null || grindingRecipes.keySet().stream().anyMatch(stack -> HarvestcraftRecipes.isSameItem(stack, input));
    }

    public static boolean doesFilteringRecipeExist(ItemStack input) {
        return waterFilterRecipes == null || waterFilterRecipes.keySet().stream().anyMatch(stack -> HarvestcraftRecipes.isSameItem(stack, input));
    }

    private static boolean isSameItem(ItemStack stack, ItemStack stack2) {
        return stack2.func_77973_b() == stack.func_77973_b() && (stack.func_77952_i() == Short.MAX_VALUE || stack2.func_77952_i() == Short.MAX_VALUE || stack2.func_77952_i() == stack.func_77952_i());
    }

    public static ItemStack getCurrency(int config, CurrencyType currencyType) {
        switch (config) {
            case 1: {
                return new ItemStack(Items.field_151045_i);
            }
            case 2: {
                return new ItemStack(Items.field_151043_k);
            }
            case 3: {
                return new ItemStack(Items.field_151074_bl);
            }
            case 4: {
                return new ItemStack(Items.field_151042_j);
            }
            case 5: {
                if (currencyType.equals((Object)CurrencyType.ANIMAL)) {
                    return new ItemStack(Items.field_151110_aK);
                }
                if (currencyType.equals((Object)CurrencyType.SEEDS)) {
                    return new ItemStack(Items.field_151014_N);
                }
                if (currencyType.equals((Object)CurrencyType.SAPLING)) {
                    return new ItemStack(Blocks.field_150345_g);
                }
            }
            case 6: {
                return new ItemStack(Items.field_151034_e);
            }
            case 7: {
                return new ItemStack(Items.field_151100_aR);
            }
            case 8: {
                return new ItemStack(ItemRegistry.garliccoinItem);
            }
        }
        return new ItemStack(Items.field_151166_bC);
    }

    static {
        Object o;
        Field items;
        Collection tempMarket = null;
        Collection tempShipping = null;
        Map tempPressing = null;
        Map tempGrinding = null;
        Map tempWaterFiltering = null;
        try {
            items = MarketItems.class.getDeclaredField("items");
            items.setAccessible(true);
            o = items.get(null);
            if (o instanceof Collection) {
                tempMarket = (Collection)o;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Mia.LOGGER.error("Could not access MarketItems.items, CraftTweaker Harvestcraft integration might not work properly");
        }
        try {
            items = ShippingBinItems.class.getDeclaredField("items");
            items.setAccessible(true);
            o = items.get(null);
            if (o instanceof Collection) {
                tempShipping = (Collection)o;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Mia.LOGGER.error("Could not access MarketBin.items, CraftTweaker Harvestcraft integration might not work properly");
        }
        try {
            items = PresserRecipes.class.getDeclaredField("pressingList");
            items.setAccessible(true);
            o = items.get(null);
            if (o instanceof Map) {
                tempPressing = (Map)o;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Mia.LOGGER.error("Could not access PressingRecipes.pressingList, CraftTweaker Harvestcraft integration might not work properly");
        }
        try {
            items = GrinderRecipes.class.getDeclaredField("grindingList");
            items.setAccessible(true);
            o = items.get(null);
            if (o instanceof Map) {
                tempGrinding = (Map)o;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Mia.LOGGER.error("Could not access GrinderRecipes.grindingList, CraftTweaker Harvestcraft integration might not work properly");
        }
        try {
            items = WaterFilterRecipes.class.getDeclaredField("waterfilterList");
            items.setAccessible(true);
            o = items.get(null);
            if (o instanceof Map) {
                tempWaterFiltering = (Map)o;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Mia.LOGGER.error("Could not access WaterFilterRecipes.waterfilterList, CraftTweaker Harvestcraft integration might not work properly");
        }
        marketRecipes = tempMarket;
        shippingRecipes = tempShipping;
        pressingRecipes = tempPressing;
        grindingRecipes = tempGrinding;
        waterFilterRecipes = tempWaterFiltering;
    }

    public static enum CurrencyType {
        DEFAULT,
        SEEDS,
        SAPLING,
        ANIMAL,
        FISH,
        MEAT,
        BEES;

    }
}

