/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.harvestcraft;

import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.jei.IJeiIntegration;
import com.github.sokyranthedragon.mia.integrations.jei.categories.lootbag.LootBagCategory;
import com.github.sokyranthedragon.mia.integrations.jei.categories.lootbag.LootBagEntry;
import com.github.sokyranthedragon.mia.integrations.jei.categories.lootbag.LootBagRegistry;
import com.github.sokyranthedragon.mia.integrations.jei.categories.lootbag.LootBagWrapper;
import com.pam.harvestcraft.blocks.BlockRegistry;
import com.pam.harvestcraft.blocks.blocks.BlockBaseGarden;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
class JeiHarvestcraftIntegration
implements IJeiIntegration {
    JeiHarvestcraftIntegration() {
    }

    @Override
    public void register(IModRegistry registry, Collection<String> registeredCategories) {
        if (registeredCategories.add("mia.loot_bag")) {
            registry.handleRecipes(LootBagEntry.class, LootBagWrapper::new, "mia.loot_bag");
            registry.addRecipes(LootBagRegistry.getRecipesOrEmpty(), "mia.loot_bag");
        }
        for (BlockBaseGarden garden : BlockRegistry.gardens.values()) {
            registry.addRecipeCatalyst((Object)new ItemStack((Block)garden), new String[]{"mia.loot_bag"});
        }
    }

    @Override
    public void registerCategories(IRecipeCategoryRegistration registry, Collection<String> registeredCategories) {
        if (registeredCategories.add("mia.loot_bag")) {
            registry.addRecipeCategories(new IRecipeCategory[]{new LootBagCategory(registry.getJeiHelpers().getGuiHelper(), new ItemStack((Block)BlockRegistry.getGarden((String)"shadedGarden")))});
        }
    }

    @Override
    public void registerRecipes() {
        LootBagRegistry registry = LootBagRegistry.getInstance();
        if (registry != null) {
            for (Map.Entry gardenEntries : BlockRegistry.gardens.entrySet()) {
                List possibleOutputs = (List)BlockBaseGarden.drops.get(gardenEntries.getKey());
                if (possibleOutputs == null || possibleOutputs.isEmpty()) continue;
                float totalWeight = possibleOutputs.size();
                Set<LootBagEntry.BagOutputEntry> bagOutputs = possibleOutputs.stream().map(entry -> new LootBagEntry.BagOutputEntry(Collections.singletonList(entry), 1.0f / totalWeight * 100.0f)).collect(Collectors.toSet());
                List<LootBagEntry> entries = LootBagEntry.getEntries(new ItemStack((Block)gardenEntries.getValue()), bagOutputs);
                for (LootBagEntry entry2 : entries) {
                    registry.registerLootBagRecipe(entry2);
                }
            }
        } else {
            Mia.LOGGER.error("Could not access Loot Bag recipe registry, this shouldn't have happened as Thaumcraft and JER are loaded. Something is very wrong.");
        }
    }

    @Override
    public ModIds getModId() {
        return ModIds.HARVESTCRAFT;
    }
}

