/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.hatchery;

import com.gendeathrow.hatchery.api.crafting.ShredderRecipe;
import com.gendeathrow.hatchery.block.nestpen.NestPenTileEntity;
import com.gendeathrow.hatchery.block.shredder.ShredderTileEntity;
import com.gendeathrow.hatchery.core.config.ConfigLootHandler;
import com.gendeathrow.hatchery.core.init.ModItems;
import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.block.BlockEggSorter;
import com.github.sokyranthedragon.mia.config.HatcheryConfiguration;
import com.github.sokyranthedragon.mia.config.MiaConfig;
import com.github.sokyranthedragon.mia.core.MiaBlocks;
import com.github.sokyranthedragon.mia.integrations.base.IBaseMod;
import com.github.sokyranthedragon.mia.integrations.base.IModIntegration;
import com.github.sokyranthedragon.mia.integrations.hatchery.IHatcheryIntegration;
import com.github.sokyranthedragon.mia.integrations.hatchery.LuckyEggLoader;
import com.github.sokyranthedragon.mia.tile.TileEggSorter;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.AspectRegistryEvent;

public class Hatchery
implements IBaseMod {
    private final List<IHatcheryIntegration> modIntegrations = new LinkedList<IHatcheryIntegration>();
    private final LuckyEggLoader loader = new LuckyEggLoader();

    @Override
    public void addIntegration(IModIntegration integration) {
        if (integration instanceof IHatcheryIntegration) {
            this.modIntegrations.add((IHatcheryIntegration)integration);
        } else {
            Mia.LOGGER.warn("Incorrect Hatchery integration with id of " + (Object)((Object)integration.getModId()) + ": " + integration.toString());
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Hatchery", (int)(this.modIntegrations.size() + 2));
        progressBar.step("setting up");
        if (HatcheryConfiguration.externalIntegrationsEnabled) {
            for (IHatcheryIntegration integration : this.modIntegrations) {
                progressBar.step(integration.getModId().modId);
                if (integration.isModEnabled()) {
                    this.loader.tryCreateNewLootFile(integration.getModId(), integration.getCurrentLootVersion(), integration.getDefaultEggDrops());
                    if (MiaConfig.disableAllRecipes) continue;
                    integration.registerShredder();
                    continue;
                }
                this.loader.loadedFiles.add(integration.getModId().modId);
            }
        }
        progressBar.step("finishing up");
        if (HatcheryConfiguration.registerCustomLuckyEggLoot) {
            this.loader.loadRemainingFiles();
        }
        ConfigLootHandler.drops.addAll(this.loader.drops);
        if (HatcheryConfiguration.disableNestingPenChickenDisplay) {
            TileEntityRendererDispatcher.field_147556_a.field_147559_m.remove(NestPenTileEntity.class);
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
    }

    @Override
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        if (!HatcheryConfiguration.hatcheryAdditionsEnabled) {
            return;
        }
        MiaBlocks.eggSorter = MiaBlocks.registerBlock(new BlockEggSorter());
        GameRegistry.registerTileEntity(TileEggSorter.class, (ResourceLocation)new ResourceLocation("mia", "egg_sorter"));
    }

    @Override
    @Optional.Method(modid="thaumcraft")
    public void registerAspects(AspectRegistryEvent event) {
        if (!HatcheryConfiguration.hatcheryAdditionsEnabled) {
            return;
        }
        event.register.registerObjectTag(new ItemStack(ModItems.hatcheryEgg), new AspectList().add(Aspect.LIFE, 5).add(Aspect.BEAST, 5));
    }

    public static ConfigLootHandler.ItemDrop getDrop(ItemStack item, int weight, int minQuantity, int maxQuantity) {
        return new ConfigLootHandler.ItemDrop(item, weight, minQuantity, maxQuantity);
    }

    public static ConfigLootHandler.ItemDrop getDrop(Item item, int meta, int weight, int minQuantity, int maxQuantity) {
        return Hatchery.getDrop(new ItemStack(item, 1, meta), weight, minQuantity, maxQuantity);
    }

    public static ConfigLootHandler.ItemDrop getDrop(Item item, int weight, int minQuantity, int maxQuantity) {
        return Hatchery.getDrop(new ItemStack(item), weight, minQuantity, maxQuantity);
    }

    public static ConfigLootHandler.ItemDrop getDrop(Item item, int meta, int weight) {
        return Hatchery.getDrop(new ItemStack(item, 1, meta), weight, 1, 1);
    }

    public static ConfigLootHandler.ItemDrop getDrop(Item item, int weight) {
        return Hatchery.getDrop(new ItemStack(item), weight, 1, 1);
    }

    public static ConfigLootHandler.ItemDrop getDrop(Block item, int meta, int weight, int minQuantity, int maxQuantity) {
        return Hatchery.getDrop(new ItemStack(item, 1, meta), weight, minQuantity, maxQuantity);
    }

    public static ConfigLootHandler.ItemDrop getDrop(Block item, int weight, int minQuantity, int maxQuantity) {
        return Hatchery.getDrop(new ItemStack(item), weight, minQuantity, maxQuantity);
    }

    public static ConfigLootHandler.ItemDrop getDrop(Block item, int meta, int weight) {
        return Hatchery.getDrop(new ItemStack(item, 1, meta), weight, 1, 1);
    }

    public static ConfigLootHandler.ItemDrop getDrop(Block item, int weight) {
        return Hatchery.getDrop(new ItemStack(item), weight, 1, 1);
    }

    public static void registerShredder(ItemStack input, ItemStack output) {
        Hatchery.registerShredder(input, output, ItemStack.field_190927_a);
    }

    public static void registerShredder(ItemStack input, ItemStack output, ItemStack extra) {
        Hatchery.registerShredder(input, output, extra, 3);
    }

    public static void registerShredder(ItemStack input, ItemStack output, ItemStack extra, int chance) {
        Hatchery.registerShredder(input, output, extra, chance, 100);
    }

    public static void registerShredder(ItemStack input, ItemStack output, ItemStack extra, int chance, int time) {
        ShredderTileEntity.shredderRecipes.add(new ShredderRecipe(input, output, extra, chance, time));
    }
}

