/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.hatchery;

import com.gendeathrow.hatchery.core.config.ConfigLootHandler;
import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

class LuckyEggLoader {
    public final List<ConfigLootHandler.ItemDrop> drops = new LinkedList<ConfigLootHandler.ItemDrop>();
    final Set<String> loadedFiles = new HashSet<String>();

    LuckyEggLoader() {
    }

    void tryCreateNewLootFile(ModIds modId, int configVersion, @Nonnull List<ConfigLootHandler.ItemDrop> loot) {
        this.loadedFiles.add(modId.modId);
        File lootFile = new File("config/mia/lucky_eggs/" + (Object)((Object)modId) + ".json");
        if (!lootFile.isFile()) {
            if (lootFile.getParentFile().isDirectory() || lootFile.getParentFile().mkdirs()) {
                this.writeConfig(lootFile, configVersion, loot);
            }
            return;
        }
        LuckyEggLootConfig config = this.loadConfig(lootFile);
        if (config == null) {
            this.drops.addAll(loot);
            return;
        }
        if (config.modCanAutomaticallyReplaceConfig && config.configVersion < configVersion) {
            this.writeConfig(lootFile, configVersion, loot);
        } else {
            config.cleanLoot();
            this.drops.addAll(config.loot);
        }
    }

    void loadRemainingFiles() {
        File configDir = new File("config/mia/lucky_eggs");
        if (configDir.isDirectory()) {
            File[] configFiles = configDir.listFiles((dir, name) -> name.endsWith(".json") && !this.loadedFiles.contains(name.substring(0, name.length() - 5)));
            if (configFiles == null) {
                return;
            }
            for (File file : configFiles) {
                LuckyEggLootConfig config = this.loadConfig(file);
                if (config == null) continue;
                config.cleanLoot();
                this.drops.addAll(config.loot);
            }
        }
    }

    private void writeConfig(File lootFile, int configVersion, List<ConfigLootHandler.ItemDrop> loot) {
        this.drops.addAll(loot);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        LuckyEggLootConfig config = new LuckyEggLootConfig(configVersion, loot);
        try (FileWriter writer = new FileWriter(lootFile);){
            gson.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException ignored) {
            Mia.LOGGER.warn("Could not save lucky egg config: " + lootFile + ", config version: " + configVersion + ", drop entries: " + loot.size());
        }
    }

    private LuckyEggLootConfig loadConfig(File lootFile) {
        Gson gson = new Gson();
        LuckyEggLootConfig config = null;
        try (FileReader reader = new FileReader(lootFile);){
            config = (LuckyEggLootConfig)gson.fromJson((Reader)reader, LuckyEggLootConfig.class);
        }
        catch (Exception ignored) {
            Mia.LOGGER.warn("Could not load lucky egg config: " + lootFile);
        }
        return config;
    }

    private static class LuckyEggLootConfig {
        boolean modCanAutomaticallyReplaceConfig = true;
        int configVersion;
        List<ConfigLootHandler.ItemDrop> loot;

        LuckyEggLootConfig(int configVersion, @Nonnull List<ConfigLootHandler.ItemDrop> loot) {
            this.configVersion = configVersion;
            this.loot = loot;
        }

        void cleanLoot() {
            this.loot = this.loot.stream().filter(entry -> entry.getItem() != null).collect(Collectors.toList());
        }
    }
}

