/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.jei.categories.cauldron;

import com.github.sokyranthedragon.mia.integrations.jei.BackgroundDrawable;
import com.github.sokyranthedragon.mia.integrations.jei.categories.cauldron.CauldronEntry;
import com.github.sokyranthedragon.mia.integrations.jei.categories.cauldron.CauldronWrapper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import pegbeard.dungeontactics.handlers.DTBlocks;

public class CauldronCategory
implements IRecipeCategory<CauldronWrapper> {
    static final BackgroundDrawable BACKGROUND = new BackgroundDrawable("textures/gui/jei/cauldron.png", 166, 59);
    private IDrawable ICON;

    public CauldronCategory(IGuiHelper helper) {
        this.ICON = helper.createDrawableIngredient((Object)new ItemStack(DTBlocks.ALCHEMYCAULDRON));
    }

    @Nonnull
    public String getUid() {
        return "mia.alchemical_cauldron";
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"mia.jei.cauldron.title", (Object[])new Object[0]);
    }

    @Nonnull
    public String getModName() {
        return "Minor Integrations & Additions";
    }

    @Nullable
    public IDrawable getIcon() {
        return this.ICON;
    }

    @Nonnull
    public IDrawable getBackground() {
        return BACKGROUND;
    }

    @ParametersAreNonnullByDefault
    public void setRecipe(IRecipeLayout recipeLayout, CauldronWrapper cauldronWrapper, IIngredients ingredients) {
        if (cauldronWrapper.getEntry() instanceof CauldronEntry.CauldronFluidEntry) {
            recipeLayout.getFluidStacks().init(1, false, 128, 11);
            recipeLayout.getFluidStacks().set(1, ((CauldronEntry.CauldronFluidEntry)cauldronWrapper.getEntry()).getTrueOutput());
        } else {
            recipeLayout.getItemStacks().init(0, false, 127, 10);
            recipeLayout.getItemStacks().set(0, cauldronWrapper.getEntry().getOutput());
        }
        recipeLayout.getItemStacks().init(1, false, 83, 10);
        recipeLayout.getItemStacks().init(2, false, 147, 10);
        recipeLayout.getItemStacks().set(1, cauldronWrapper.getEntry().getRightClickItem());
        recipeLayout.getItemStacks().set(2, cauldronWrapper.getEntry().getByproduct());
        for (int i = 0; i < Math.min(3, cauldronWrapper.getEntry().getInputs().size()); ++i) {
            recipeLayout.getItemStacks().init(i + 3, true, 11 + 17 * i, 10);
            recipeLayout.getItemStacks().set(i + 3, cauldronWrapper.getEntry().getInputs().get(i));
        }
        FluidStack fluid = cauldronWrapper.getEntry().getFluid();
        if (fluid != null) {
            recipeLayout.getFluidStacks().init(0, false, 38, 30);
            recipeLayout.getFluidStacks().set(0, fluid);
        } else if (cauldronWrapper.getEntry().getPossibleFluids() == CauldronEntry.PossibleFluids.NoWater) {
            recipeLayout.getItemStacks().init(6, false, 37, 29);
            recipeLayout.getItemStacks().set(6, new ItemStack(Blocks.field_180401_cv));
        }
        recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)cauldronWrapper);
    }
}

