/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.jei.categories.lootbag;

import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.utilities.LootTableUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import jeresources.util.LootTableHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraft.world.storage.loot.functions.SetNBT;

public class LootBagEntry {
    private List<ItemStack> lootBag;
    private List<BagOutputEntry> possibleOutput;

    private LootBagEntry(List<ItemStack> lootBag, List<BagOutputEntry> possibleOutput) {
        this.lootBag = lootBag;
        this.possibleOutput = possibleOutput;
    }

    @Nonnull
    public static List<LootBagEntry> getEntries(List<ItemStack> lootBags, @Nonnull Collection<BagOutputEntry> possibleOutputs) {
        if (possibleOutputs.size() == 0 || lootBags.isEmpty()) {
            return new ArrayList<LootBagEntry>();
        }
        ArrayList<LootBagEntry> pages = new ArrayList<LootBagEntry>(MathHelper.func_76123_f((float)((float)possibleOutputs.size() / 36.0f)));
        ArrayList<BagOutputEntry> items = new ArrayList<BagOutputEntry>(36);
        for (BagOutputEntry possibleOutput : possibleOutputs) {
            if (possibleOutput.items.isEmpty()) continue;
            items.add(possibleOutput);
            if (items.size() != 36) continue;
            pages.add(new LootBagEntry(lootBags, items));
            items = new ArrayList();
        }
        if (items.size() > 0) {
            pages.add(new LootBagEntry(lootBags, items));
        }
        return pages;
    }

    @Nonnull
    public static List<LootBagEntry> getEntries(ItemStack lootBag, @Nonnull Collection<BagOutputEntry> possibleOutputs) {
        return LootBagEntry.getEntries(Lists.newArrayList((Object[])new ItemStack[]{lootBag}), possibleOutputs);
    }

    @Nonnull
    public static List<LootBagEntry> getEntries(ItemStack lootBag, @Nonnull ResourceLocation resourceLocation) {
        if (!ModIds.JER.isLoaded || lootBag.func_190926_b()) {
            return new ArrayList<LootBagEntry>();
        }
        ArrayList<BagOutputEntry> drops = new ArrayList<BagOutputEntry>();
        LootTableManager manager = LootTableHelper.getManager();
        LootBagEntry.toDrops(manager, resourceLocation, drops);
        return LootBagEntry.getEntries(lootBag, drops);
    }

    public List<ItemStack> getInput() {
        return this.lootBag;
    }

    public List<BagOutputEntry> getOutputs() {
        return this.possibleOutput;
    }

    public static void toDrops(LootTableManager manager, ResourceLocation resourceLocation, Collection<BagOutputEntry> possibleOutputs) {
        LootTableUtils.getPools(manager.func_186521_a(resourceLocation)).forEach(pool -> {
            float totalWeight = LootTableUtils.getEntries(pool).stream().mapToInt(entry -> entry.func_186361_a(0.0f)).sum();
            LootTableUtils.getEntries(pool).stream().filter(entry -> entry instanceof LootEntryItem).map(entry -> (LootEntryItem)entry).map(entry -> new BagOutputEntry(LootBagEntry.applyFunction(LootTableUtils.getItem(entry), LootTableUtils.getFunctions(entry)), (float)entry.func_186361_a(0.0f) / totalWeight * 100.0f)).forEach(possibleOutputs::add);
            LootTableUtils.getEntries(pool).stream().filter(entry -> entry instanceof LootEntryTable).map(entry -> (LootEntryTable)entry).forEach(entry -> LootBagEntry.toDrops(manager, LootTableUtils.getTable(entry), possibleOutputs));
        });
        possibleOutputs.removeIf(entry -> ((BagOutputEntry)entry).items.size() == 0);
    }

    private static List<ItemStack> applyFunction(Item item, LootFunction[] functions) {
        int min = 0;
        int max = 0;
        SetNBT tag = null;
        for (LootFunction function : functions) {
            if (function instanceof SetMetadata) {
                RandomValueRange range = LootTableUtils.getMetaRange((SetMetadata)function);
                min = (int)range.func_186509_a();
                max = (int)range.func_186512_b();
                continue;
            }
            if (!(function instanceof SetNBT)) continue;
            tag = (SetNBT)function;
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = min; i <= max; ++i) {
            items.add(LootBagEntry.createItem(item, i, tag));
        }
        if (items.size() == 0) {
            items.add(LootBagEntry.createItem(item, 0, tag));
        }
        return items;
    }

    private static ItemStack createItem(Item item, int meta, SetNBT tag) {
        ItemStack stack = new ItemStack(item, 1, meta);
        if (tag != null) {
            tag.func_186553_a(stack, null, null);
        }
        return stack;
    }

    public static class BagOutputEntry {
        private List<ItemStack> items;
        private float chance;

        public BagOutputEntry(List<ItemStack> items, float chance) {
            this.items = items.stream().filter(stack -> stack != null && !stack.func_190926_b()).collect(Collectors.toList());
            this.chance = chance;
        }

        public List<ItemStack> getItems() {
            return this.items;
        }

        public float getChance() {
            return this.chance;
        }
    }
}

