/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.jei.categories.lootbag;

import com.github.sokyranthedragon.mia.integrations.jei.categories.lootbag.LootBagEntry;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LootBagRegistry {
    private Set<LootBagEntry> registry;
    private static LootBagRegistry instance;

    private LootBagRegistry() {
    }

    public static LootBagRegistry getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new LootBagRegistry();
        LootBagRegistry.instance.registry = new LinkedHashSet<LootBagEntry>();
        return instance;
    }

    public boolean registerLootBagRecipe(@Nullable LootBagEntry entry) {
        return entry != null && this.registry.add(entry);
    }

    @Nonnull
    public Set<LootBagEntry> getRecipes() {
        return this.registry;
    }

    @Nonnull
    public static Set<LootBagEntry> getRecipesOrEmpty() {
        return LootBagRegistry.getInstance() != null ? LootBagRegistry.getInstance().getRecipes() : new HashSet<LootBagEntry>();
    }

    public void clear() {
        this.registry.clear();
    }
}

