/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.jer;

import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.jei.IJeiIntegration;
import com.github.sokyranthedragon.mia.integrations.jer.JustEnoughResources;
import com.github.sokyranthedragon.mia.integrations.jer.custom.CustomPlantWrapper;
import com.github.sokyranthedragon.mia.integrations.jer.custom.CustomVillagerWrapper;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import jeresources.entry.PlantEntry;
import jeresources.entry.VillagerEntry;
import jeresources.jei.plant.PlantWrapper;
import jeresources.jei.villager.VillagerWrapper;
import mcp.MethodsReturnNonnullByDefault;
import mezz.jei.JustEnoughItems;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.collect.ListMultiMap;
import mezz.jei.collect.SetMultiMap;
import mezz.jei.plugins.vanilla.VanillaPlugin;
import mezz.jei.startup.ProxyCommon;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
class JeiJerIntegration
implements IJeiIntegration {
    boolean registeredPlants = false;
    boolean registeredVillagers = false;

    JeiJerIntegration() {
    }

    public boolean initializePlugins(final JustEnoughResources jer) {
        try {
            ProxyCommon proxy = JustEnoughItems.getProxy();
            Field pluginsField = proxy.getClass().getDeclaredField("plugins");
            pluginsField.setAccessible(true);
            Object o = pluginsField.get(proxy);
            if (o instanceof List) {
                List plugins = (List)o;
                int safeIndex = 0;
                for (IModPlugin plugin : plugins) {
                    ++safeIndex;
                    if (plugin instanceof VanillaPlugin) continue;
                    break;
                }
                plugins.add(safeIndex, new IModPlugin(){

                    public void register(@Nonnull IModRegistry registry) {
                        try {
                            if (!JeiJerIntegration.this.registeredPlants) {
                                JeiJerIntegration.this.registeredPlants = JeiJerIntegration.registerCustomPlants(registry);
                            }
                            if (!JeiJerIntegration.this.registeredVillagers) {
                                JeiJerIntegration.this.registeredVillagers = JeiJerIntegration.registerCustomVillagers(registry);
                            }
                            jer.initJerIntegration();
                        }
                        catch (Exception e) {
                            Mia.LOGGER.error("Encountered an issue registering JER entries! (Early-insertion registration)");
                            e.printStackTrace();
                        }
                    }
                });
                return true;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Mia.LOGGER.error("Could not access JEI plugin list, there might be some issues with mob drops not working ");
        }
        return false;
    }

    @Override
    public void register(IModRegistry registry, Collection<String> registeredCategories) {
        if (!this.registeredPlants) {
            this.registeredPlants = JeiJerIntegration.registerCustomPlants(registry);
        }
        if (!this.registeredVillagers) {
            this.registeredVillagers = JeiJerIntegration.registerCustomVillagers(registry);
        }
    }

    public static boolean registerCustomPlants(IModRegistry registry) {
        try {
            Field recipeHandlerClassesField = registry.getClass().getDeclaredField("recipeHandlerClasses");
            Field recipeHandlersField = registry.getClass().getDeclaredField("recipeHandlers");
            recipeHandlerClassesField.setAccessible(true);
            recipeHandlersField.setAccessible(true);
            SetMultiMap recipeHandlerClasses = (SetMultiMap)recipeHandlerClassesField.get(registry);
            ListMultiMap recipeHandlers = (ListMultiMap)recipeHandlersField.get(registry);
            if (!recipeHandlerClasses.contains((Object)"jeresources.plant", PlantEntry.class)) {
                recipeHandlerClasses.put((Object)"jeresources.plant", PlantEntry.class);
            }
            IRecipeHandler<PlantEntry> recipeHandler = new IRecipeHandler<PlantEntry>(){

                public Class<PlantEntry> getRecipeClass() {
                    return PlantEntry.class;
                }

                public String getRecipeCategoryUid(PlantEntry plantEntry) {
                    return "jeresources.plant";
                }

                public IRecipeWrapper getRecipeWrapper(PlantEntry plantEntry) {
                    return new CustomPlantWrapper(plantEntry);
                }

                public boolean isRecipeValid(PlantEntry plantEntry) {
                    return true;
                }
            };
            List plantHandlers = (List)recipeHandlers.get((Object)"jeresources.plant");
            if (plantHandlers.size() > 0) {
                plantHandlers.removeIf(handler -> handler.getRecipeWrapper(null) instanceof PlantWrapper);
            }
            plantHandlers.add(recipeHandler);
            return true;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Mia.LOGGER.error("Could not access ModRegistry, custom plant drops won't work properly.");
            return false;
        }
    }

    public static boolean registerCustomVillagers(IModRegistry registry) {
        try {
            Field recipeHandlerClassesField = registry.getClass().getDeclaredField("recipeHandlerClasses");
            Field recipeHandlersField = registry.getClass().getDeclaredField("recipeHandlers");
            recipeHandlerClassesField.setAccessible(true);
            recipeHandlersField.setAccessible(true);
            SetMultiMap recipeHandlerClasses = (SetMultiMap)recipeHandlerClassesField.get(registry);
            ListMultiMap recipeHandlers = (ListMultiMap)recipeHandlersField.get(registry);
            if (!recipeHandlerClasses.contains((Object)"jeresources.villager", VillagerEntry.class)) {
                recipeHandlerClasses.put((Object)"jeresources.villager", VillagerEntry.class);
            }
            IRecipeHandler<VillagerEntry> recipeHandler = new IRecipeHandler<VillagerEntry>(){

                public Class<VillagerEntry> getRecipeClass() {
                    return VillagerEntry.class;
                }

                public String getRecipeCategoryUid(VillagerEntry villagerEntry) {
                    return "jeresources.villager";
                }

                public IRecipeWrapper getRecipeWrapper(VillagerEntry villagerEntry) {
                    return new CustomVillagerWrapper(villagerEntry);
                }

                public boolean isRecipeValid(VillagerEntry villagerEntry) {
                    return true;
                }
            };
            List villagerHandlers = (List)recipeHandlers.get((Object)"jeresources.villager");
            if (villagerHandlers.size() > 0) {
                villagerHandlers.removeIf(handler -> handler.getRecipeWrapper(null) instanceof VillagerWrapper);
            }
            villagerHandlers.add(recipeHandler);
            return true;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Mia.LOGGER.error("Could not access ModRegistry, custom villager drops won't work properly.");
            return false;
        }
    }

    @Override
    public ModIds getModId() {
        return ModIds.JER;
    }
}

