/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.jer;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.lang.reflect.Constructor;
import jeresources.api.conditionals.LightLevel;

public class JerLightHelper {
    private static final TIntObjectHashMap<LightLevel> lightLevelsBelow = new TIntObjectHashMap();
    private static final TIntObjectHashMap<LightLevel> lightLevelsAbove = new TIntObjectHashMap();

    private JerLightHelper() {
    }

    public static LightLevel getLightLevelBelow(int value) {
        return JerLightHelper.getLightLevel(value, LightLevel.Relative.below);
    }

    public static LightLevel getLightLevelAbove(int value) {
        return JerLightHelper.getLightLevel(value, LightLevel.Relative.above);
    }

    private static LightLevel getLightLevel(int value, LightLevel.Relative relative) {
        LightLevel light;
        if (relative == LightLevel.Relative.below) {
            if (lightLevelsBelow.containsKey(value)) {
                return (LightLevel)lightLevelsBelow.get(value);
            }
        } else if (lightLevelsAbove.containsKey(value)) {
            return (LightLevel)lightLevelsAbove.get(value);
        }
        if ((light = JerLightHelper.createLightLevel(value, relative)) != null) {
            if (relative == LightLevel.Relative.below) {
                lightLevelsBelow.put(value, (Object)light);
            } else {
                lightLevelsAbove.put(value, (Object)light);
            }
            return light;
        }
        return LightLevel.any;
    }

    private static LightLevel createLightLevel(int value, LightLevel.Relative relative) {
        try {
            Constructor constructor = LightLevel.class.getDeclaredConstructor(Integer.TYPE, LightLevel.Relative.class);
            constructor.setAccessible(true);
            return (LightLevel)constructor.newInstance(value, relative);
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        lightLevelsBelow.put(4, (Object)LightLevel.bat);
        lightLevelsBelow.put(8, (Object)LightLevel.hostile);
        lightLevelsBelow.put(12, (Object)LightLevel.blaze);
        lightLevelsAbove.put(-1, (Object)LightLevel.any);
    }
}

