/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.quark;

import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.chisel.IChiselIntegration;
import com.github.sokyranthedragon.mia.utilities.QuarkUtils;
import java.util.function.BiConsumer;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.util.TriConsumer;
import team.chisel.common.config.Configurations;
import vazkii.quark.building.block.BlockWorldStoneBricks;
import vazkii.quark.building.feature.CarvedWood;
import vazkii.quark.building.feature.HardenedClayTiles;
import vazkii.quark.building.feature.MidoriBlocks;
import vazkii.quark.building.feature.MoreSandstone;
import vazkii.quark.building.feature.PolishedNetherrack;
import vazkii.quark.building.feature.PolishedStone;
import vazkii.quark.building.feature.SoulSandstone;
import vazkii.quark.building.feature.VerticalWoodPlanks;
import vazkii.quark.building.feature.WorldStoneBricks;
import vazkii.quark.building.feature.WorldStonePavement;
import vazkii.quark.decoration.feature.VariedBookshelves;
import vazkii.quark.world.feature.Biotite;
import vazkii.quark.world.feature.UndergroundBiomes;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
class ChiselQuarkIntegration
implements IChiselIntegration {
    ChiselQuarkIntegration() {
    }

    @Override
    public void sendChiselMessages(BiConsumer<String, ItemStack[]> messageStackSender, TriConsumer<String, Block, Integer> messageBlockSender) {
        int meta;
        if (QuarkUtils.isFeatureEnabled(Biotite.class)) {
            for (meta = 0; meta <= 2; ++meta) {
                messageBlockSender.accept((Object)"biotite", (Object)Biotite.biotite_block, (Object)meta);
            }
        }
        if (QuarkUtils.isFeatureEnabled(UndergroundBiomes.class)) {
            if (UndergroundBiomes.firestoneEnabled) {
                messageBlockSender.accept((Object)"brimstone", (Object)UndergroundBiomes.biome_cobblestone, (Object)0);
                messageBlockSender.accept((Object)"brimstone", (Object)UndergroundBiomes.biome_brick, (Object)0);
            }
            if (UndergroundBiomes.icystoneEnabled) {
                messageBlockSender.accept((Object)"permafrost", (Object)UndergroundBiomes.biome_cobblestone, (Object)1);
                messageBlockSender.accept((Object)"permafrost", (Object)UndergroundBiomes.biome_brick, (Object)1);
            }
        }
        if (QuarkUtils.isFeatureEnabled(MoreSandstone.class)) {
            for (meta = 0; meta <= 1; ++meta) {
                messageBlockSender.accept((Object)"sandstone", (Object)MoreSandstone.sandstone_new, (Object)meta);
                messageBlockSender.accept((Object)"sandstonered", (Object)MoreSandstone.sandstone_new, (Object)(meta + 2));
                if (!QuarkUtils.isFeatureEnabled(SoulSandstone.class)) continue;
                messageBlockSender.accept((Object)"sandstonesoul", (Object)MoreSandstone.sandstone_new, (Object)(meta + 4));
            }
        }
        if (QuarkUtils.isFeatureEnabled(SoulSandstone.class)) {
            for (meta = 0; meta <= 2; ++meta) {
                messageBlockSender.accept((Object)"sandstonesoul", (Object)SoulSandstone.soul_sandstone, (Object)meta);
            }
        }
        if (QuarkUtils.isFeatureEnabled(PolishedStone.class) && Configurations.allowSmoothStone) {
            messageBlockSender.accept((Object)"stonebrick", (Object)PolishedStone.polished_stone, (Object)0);
        }
        if (QuarkUtils.isFeatureEnabled(HardenedClayTiles.class)) {
            messageBlockSender.accept((Object)"hardenedclay", (Object)HardenedClayTiles.hardened_clay_tiles, (Object)0);
            if (HardenedClayTiles.enableStainedClay) {
                for (meta = 0; meta < EnumDyeColor.values().length; ++meta) {
                    EnumDyeColor color = EnumDyeColor.values()[meta];
                    messageBlockSender.accept((Object)("hardenedclaydyed_" + color.func_176610_l()), (Object)Blocks.field_150406_ce, (Object)meta);
                    messageBlockSender.accept((Object)("hardenedclaydyed_" + color.func_176610_l()), (Object)HardenedClayTiles.stained_clay_tiles, (Object)meta);
                }
            }
        }
        if (QuarkUtils.isFeatureEnabled(WorldStoneBricks.class) || QuarkUtils.isFeatureEnabled(WorldStonePavement.class)) {
            for (meta = 0; meta < BlockWorldStoneBricks.Variants.values().length; ++meta) {
                BlockWorldStoneBricks.Variants variant = BlockWorldStoneBricks.Variants.values()[meta];
                if (!variant.isEnabled()) continue;
                if (QuarkUtils.isFeatureEnabled(WorldStoneBricks.class)) {
                    messageBlockSender.accept((Object)variant.blockName, (Object)WorldStoneBricks.world_stone_chiseled, (Object)meta);
                }
                if (!QuarkUtils.isFeatureEnabled(WorldStonePavement.class)) continue;
                messageBlockSender.accept((Object)variant.blockName, (Object)WorldStonePavement.world_stone_pavement, (Object)meta);
            }
        }
        if (QuarkUtils.isFeatureEnabled(MidoriBlocks.class)) {
            for (meta = 0; meta <= 1; ++meta) {
                messageBlockSender.accept((Object)"midori", (Object)MidoriBlocks.midori_block, (Object)meta);
            }
        }
        if (QuarkUtils.isFeatureEnabled(PolishedNetherrack.class)) {
            for (meta = 0; meta <= 1; ++meta) {
                messageBlockSender.accept((Object)"netherrack", (Object)PolishedNetherrack.polished_netherrack, (Object)meta);
            }
        }
        if (QuarkUtils.isFeatureEnabled(VerticalWoodPlanks.class)) {
            String[] types = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark-oak"};
            for (int meta2 = 0; meta2 < types.length; ++meta2) {
                messageBlockSender.accept((Object)("planks-" + types[meta2]), (Object)VerticalWoodPlanks.vertical_planks, (Object)meta2);
            }
        }
        if (QuarkUtils.isFeatureEnabled(CarvedWood.class)) {
            String[] types = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark-oak"};
            for (int meta3 = 0; meta3 < types.length; ++meta3) {
                messageBlockSender.accept((Object)("planks-" + types[meta3]), (Object)CarvedWood.carvedWood, (Object)meta3);
            }
        }
        if (QuarkUtils.isFeatureEnabled(VariedBookshelves.class)) {
            String[] types = new String[]{"spruce", "birch", "jungle", "acacia", "darkoak"};
            for (int meta4 = 0; meta4 < types.length; ++meta4) {
                messageBlockSender.accept((Object)("bookshelf_" + types[meta4]), (Object)VariedBookshelves.custom_bookshelf, (Object)meta4);
            }
        }
    }

    @Override
    public ModIds getModId() {
        return ModIds.QUARK;
    }
}

