/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.quark;

import cofh.thermalfoundation.item.ItemMaterial;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.xu2.IExtraUtilsIntegration;
import com.github.sokyranthedragon.mia.utilities.ItemStackUtils;
import com.github.sokyranthedragon.mia.utilities.QuarkUtils;
import com.rwtema.extrautils2.api.machine.Machine;
import com.rwtema.extrautils2.api.machine.MachineSlotItem;
import com.rwtema.extrautils2.api.machine.RecipeBuilder;
import com.rwtema.extrautils2.api.machine.XUMachineCrusher;
import com.rwtema.extrautils2.api.machine.XUMachineGenerators;
import com.rwtema.extrautils2.blocks.BlockTerraformer;
import com.rwtema.extrautils2.items.itemmatching.IMatcherMaker;
import com.rwtema.extrautils2.tile.TileTerraformerClimograph;
import com.rwtema.extrautils2.utils.datastructures.ItemRef;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import vazkii.quark.automation.feature.ColorSlime;
import vazkii.quark.automation.feature.SugarBlock;
import vazkii.quark.decoration.feature.BlazeLantern;
import vazkii.quark.misc.feature.BlackAsh;
import vazkii.quark.world.feature.Biotite;
import vazkii.quark.world.feature.UndergroundBiomes;
import vazkii.quark.world.feature.Wraiths;

class ExtraUtilsQuarkIntegration
implements IExtraUtilsIntegration {
    ExtraUtilsQuarkIntegration() {
    }

    @Override
    public void addRecipes(@Nullable MachineSlotItem slimeSecondary) {
        if (QuarkUtils.isFeatureEnabled(Biotite.class)) {
            XUMachineCrusher.addRecipe((ItemStack)new ItemStack(Biotite.biotite_ore), (ItemStack)new ItemStack(Biotite.biotite), (ItemStack)new ItemStack(Biotite.biotite, 3), (float)0.2f);
            for (int meta = 0; meta <= 2; ++meta) {
                XUMachineCrusher.addRecipe((ItemStack)new ItemStack(Biotite.biotite_block, 1, meta), (ItemStack)new ItemStack(Biotite.biotite, 4));
            }
            ItemStackUtils.getStack(ModIds.QUARK, "biotite_slab").ifPresent(slab -> XUMachineCrusher.addRecipe((ItemStack)slab, (ItemStack)new ItemStack(Biotite.biotite, 1)));
            ItemStackUtils.getStack(ModIds.QUARK, "biotite_stairs").ifPresent(stairs -> XUMachineCrusher.addRecipe((ItemStack)stairs, (ItemStack)new ItemStack(Biotite.biotite, 2)));
        }
        if (QuarkUtils.isFeatureEnabled(UndergroundBiomes.class)) {
            if (UndergroundBiomes.firestoneEnabled) {
                XUMachineCrusher.addRecipe((ItemStack)new ItemStack((Block)UndergroundBiomes.biome_cobblestone, 1, 0), (ItemStack)new ItemStack(Blocks.field_150351_n), (ItemStack)new ItemStack(Items.field_151065_br), (float)0.05f);
                TileTerraformerClimograph.register((BlockTerraformer.Type)BlockTerraformer.Type.HEATER, (IMatcherMaker)ItemRef.wrap((ItemStack)new ItemStack((Block)UndergroundBiomes.biome_cobblestone, 1, 0)), (int)8);
            }
            if (UndergroundBiomes.icystoneEnabled) {
                XUMachineCrusher.addRecipe((ItemStack)new ItemStack((Block)UndergroundBiomes.biome_cobblestone, 1, 1), (ItemStack)new ItemStack(Blocks.field_150351_n), (ItemStack)(ModIds.THERMAL_FOUNDATION.isLoaded ? ItemMaterial.dustBlizz : new ItemStack(Items.field_151126_ay)), (float)0.05f);
                TileTerraformerClimograph.register((BlockTerraformer.Type)BlockTerraformer.Type.COOLER, (IMatcherMaker)ItemRef.wrap((ItemStack)new ItemStack((Block)UndergroundBiomes.biome_cobblestone, 1, 1)), (int)8);
            }
        }
        if (QuarkUtils.isFeatureEnabled(BlazeLantern.class)) {
            XUMachineCrusher.addRecipe((ItemStack)new ItemStack((Block)BlazeLantern.blaze_lantern), (ItemStack)new ItemStack(Items.field_151065_br, 16));
            TileTerraformerClimograph.register((BlockTerraformer.Type)BlockTerraformer.Type.HEATER, (IMatcherMaker)ItemRef.wrap((Block)BlazeLantern.blaze_lantern), (int)37);
        }
        if (QuarkUtils.isFeatureEnabled(SugarBlock.class)) {
            TileTerraformerClimograph.register((BlockTerraformer.Type)BlockTerraformer.Type.HUMIDIFIER, (IMatcherMaker)ItemRef.wrap((Block)SugarBlock.sugar_block), (int)36);
        }
        if (QuarkUtils.isFeatureEnabled(BlackAsh.class)) {
            XUMachineGenerators.DEATH_GENERATOR.recipes_registry.addRecipe(RecipeBuilder.newbuilder((Machine)XUMachineGenerators.DEATH_GENERATOR).setRFRate(10333, 80.0f).setItemInput(XUMachineGenerators.INPUT_ITEM, new ItemStack(BlackAsh.black_ash), 1).build());
        }
        if (QuarkUtils.isFeatureEnabled(Wraiths.class)) {
            XUMachineGenerators.DEATH_GENERATOR.recipes_registry.addRecipe(RecipeBuilder.newbuilder((Machine)XUMachineGenerators.DEATH_GENERATOR).setRFRate(8000, 20.0f).setItemInput(XUMachineGenerators.INPUT_ITEM, new ItemStack(Wraiths.soul_bead), 1).build());
        }
        if (QuarkUtils.isFeatureEnabled(ColorSlime.class) && slimeSecondary != null) {
            ArrayList<ItemStack> slimeList = new ArrayList<ItemStack>();
            for (int meta = 0; meta <= 4; ++meta) {
                slimeList.add(new ItemStack(ColorSlime.color_slime, 1, meta));
            }
            XUMachineGenerators.SLIME_GENERATOR.recipes_registry.addRecipe(RecipeBuilder.newbuilder((Machine)XUMachineGenerators.SLIME_GENERATOR).setRFRate(432000, 400.0f).setItemInput(XUMachineGenerators.INPUT_ITEM, slimeList, 1).setItemInput(slimeSecondary, new ItemStack(Items.field_151117_aB, 1)).build());
        }
    }

    @Override
    @Nonnull
    public ModIds getModId() {
        return ModIds.QUARK;
    }
}

