/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.quark;

import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.config.MiaConfig;
import com.github.sokyranthedragon.mia.config.QuarkConfiguration;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.base.IBaseMod;
import com.github.sokyranthedragon.mia.integrations.base.IModIntegration;
import com.github.sokyranthedragon.mia.integrations.quark.ChiselQuarkIntegration;
import com.github.sokyranthedragon.mia.integrations.quark.DungeonTacticsQuarkIntegration;
import com.github.sokyranthedragon.mia.integrations.quark.ExtraUtilsQuarkIntegration;
import com.github.sokyranthedragon.mia.integrations.quark.FutureMcQuarkIntegration;
import com.github.sokyranthedragon.mia.integrations.quark.IQuarkIntegration;
import com.github.sokyranthedragon.mia.integrations.quark.IndustrialForegoingQuarkIntegration;
import com.github.sokyranthedragon.mia.integrations.quark.JerQuarkIntegration;
import com.github.sokyranthedragon.mia.integrations.quark.TConstructQuarkIntegration;
import com.github.sokyranthedragon.mia.integrations.quark.ThermalExpansionQuarkIntegration;
import com.github.sokyranthedragon.mia.utilities.QuarkUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.building.feature.Trowel;
import vazkii.quark.client.feature.EnchantedBooksShowItems;
import vazkii.quark.misc.feature.AncientTomes;
import vazkii.quark.world.feature.Biotite;
import vazkii.quark.world.feature.Crabs;
import vazkii.quark.world.feature.Frogs;
import vazkii.quark.world.feature.UndergroundBiomes;

public class Quark
implements IBaseMod {
    private List<IQuarkIntegration> modIntegrations = new ArrayList<IQuarkIntegration>();

    @Override
    public void register(BiConsumer<ModIds, IModIntegration> modIntegration) {
        if (QuarkConfiguration.enableXu2Integration && ModIds.EXTRA_UTILITIES.isLoaded) {
            modIntegration.accept(ModIds.EXTRA_UTILITIES, new ExtraUtilsQuarkIntegration());
        }
        if (QuarkConfiguration.enableTeIntegration && ModIds.THERMAL_EXPANSION.isLoaded) {
            modIntegration.accept(ModIds.THERMAL_EXPANSION, new ThermalExpansionQuarkIntegration());
        }
        if (QuarkConfiguration.enableJerIntegration && ModIds.JER.isLoaded) {
            modIntegration.accept(ModIds.JER, new JerQuarkIntegration());
        }
        if (QuarkConfiguration.enableDungeonTacticsIntegration && ModIds.DUNGEON_TACTICS.isLoaded) {
            modIntegration.accept(ModIds.DUNGEON_TACTICS, new DungeonTacticsQuarkIntegration());
        }
        if (QuarkConfiguration.enableFutureMcIntegration && ModIds.FUTURE_MC.isLoaded) {
            modIntegration.accept(ModIds.FUTURE_MC, new FutureMcQuarkIntegration());
        }
        if (QuarkConfiguration.enableChiselIntegration && ModIds.CHISEL.isLoaded) {
            modIntegration.accept(ModIds.CHISEL, new ChiselQuarkIntegration());
        }
        if (QuarkConfiguration.enableIFIntegration && ModIds.INDUSTRIAL_FOREGOING.isLoaded) {
            modIntegration.accept(ModIds.INDUSTRIAL_FOREGOING, new IndustrialForegoingQuarkIntegration());
        }
        if (QuarkConfiguration.enableTConstructIntegration && ModIds.TINKERS_CONSTRUCT.isLoaded) {
            modIntegration.accept(ModIds.TINKERS_CONSTRUCT, new TConstructQuarkIntegration());
        }
    }

    @Override
    public void addIntegration(IModIntegration integration) {
        if (!QuarkConfiguration.externalIntegrationsEnabled) {
            return;
        }
        if (integration instanceof IQuarkIntegration) {
            this.modIntegrations.add((IQuarkIntegration)integration);
        } else {
            Mia.LOGGER.warn("Incorrect XU2 integration with id of " + (Object)((Object)integration.getModId()) + ": " + integration.toString());
        }
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        Feature ancientTomesFeature = (Feature)ModuleLoader.featureInstances.get(AncientTomes.class);
        if (QuarkConfiguration.addAncientTomes && !this.modIntegrations.isEmpty() && ancientTomesFeature.isEnabled()) {
            ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Quark ancient tomes", (int)(this.modIntegrations.size() + 1));
            ArrayList<String> tempEnchants = new ArrayList<String>();
            for (IQuarkIntegration integration : this.modIntegrations) {
                progressBar.step(integration.getModId().modId);
                tempEnchants.addAll(integration.getAllowedAncientTomeEnchants());
            }
            progressBar.step("adding tomes");
            if (!tempEnchants.isEmpty()) {
                try {
                    Field enchantNames = AncientTomes.class.getDeclaredField("enchantNames");
                    enchantNames.setAccessible(true);
                    Object obj = enchantNames.get(ancientTomesFeature);
                    if (obj instanceof String[]) {
                        ArrayList<String> enchants = new ArrayList<String>();
                        Collections.addAll(enchants, (String[])obj);
                        enchants.addAll(tempEnchants);
                        enchantNames.set(ancientTomesFeature, enchants.toArray(new String[0]));
                    }
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    Mia.LOGGER.error("Could not access Quark AncientTomes.enchantNames, no default ancient tome insertions will be added.");
                }
            }
            ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        if (QuarkConfiguration.addItemTooltips && event.getSide() == Side.CLIENT && !this.modIntegrations.isEmpty() && QuarkUtils.isFeatureEnabled(EnchantedBooksShowItems.class)) {
            ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Quark enchantment tooltips", (int)(this.modIntegrations.size() + 1));
            ArrayList<ItemStack> tempItems = new ArrayList<ItemStack>();
            for (IQuarkIntegration integration : this.modIntegrations) {
                progressBar.step(integration.getModId().modId);
                tempItems.addAll(integration.getItemsToShowEnchantmentsFor());
            }
            progressBar.step("adding tooltips");
            if (!tempItems.isEmpty()) {
                try {
                    Field testItems = EnchantedBooksShowItems.class.getDeclaredField("testItemLocations");
                    testItems.setAccessible(true);
                    Object obj = testItems.get(testItems);
                    if (obj instanceof List) {
                        List items = (List)obj;
                        for (ItemStack item : tempItems) {
                            items.add(Pair.of((Object)item.func_77973_b().getRegistryName(), (Object)item.func_77960_j()));
                        }
                    }
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    Mia.LOGGER.error("Could not access Quark EnchantedBooksShowItems.testItemLocations, no default items to be displayed on enchanted books will be added.");
                }
            }
            ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        }
        if (QuarkConfiguration.quarkAdditionsEnabled) {
            if (QuarkUtils.isFeatureEnabled(Trowel.class) && !MiaConfig.disableAllRecipes) {
                FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(Trowel.trowel), new ItemStack(Items.field_191525_da), 0.1f);
            }
            if (!MiaConfig.disableOreDict) {
                if (QuarkUtils.isFeatureEnabled(Frogs.class)) {
                    OreDictionary.registerOre((String)"foodFrograw", (Item)Frogs.frogLeg);
                    OreDictionary.registerOre((String)"foodFrogcooked", (Item)Frogs.cookedFrogLeg);
                }
                if (QuarkUtils.isFeatureEnabled(Crabs.class)) {
                    OreDictionary.registerOre((String)"foodCrabraw", (Item)Crabs.crabLeg);
                    OreDictionary.registerOre((String)"foodCrabcooked", (Item)Crabs.cookedCrabLeg);
                }
                if (QuarkUtils.isFeatureEnabled(Biotite.class)) {
                    OreDictionary.registerOre((String)"oreEnderBiotite", (Block)Biotite.biotite_ore);
                }
                if (QuarkUtils.isFeatureEnabled(UndergroundBiomes.class)) {
                    OreDictionary.registerOre((String)"listAllmushroom", (Block)UndergroundBiomes.glowshroom);
                }
            }
        }
    }
}

