/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.quark;

import cofh.thermalexpansion.util.managers.device.FactorizerManager;
import cofh.thermalexpansion.util.managers.machine.CrucibleManager;
import cofh.thermalexpansion.util.managers.machine.EnchanterManager;
import cofh.thermalexpansion.util.managers.machine.ExtruderManager;
import cofh.thermalexpansion.util.managers.machine.PulverizerManager;
import cofh.thermalexpansion.util.managers.machine.SmelterManager;
import cofh.thermalfoundation.item.ItemMaterial;
import com.github.sokyranthedragon.mia.config.QuarkConfiguration;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.thermalexpansion.IThermalExpansionIntegration;
import com.github.sokyranthedragon.mia.utilities.QuarkUtils;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import vazkii.quark.automation.feature.ChainLinkage;
import vazkii.quark.automation.feature.MetalButtons;
import vazkii.quark.automation.feature.PistonSpikes;
import vazkii.quark.building.feature.SoulSandstone;
import vazkii.quark.building.feature.Trowel;
import vazkii.quark.decoration.feature.Grate;
import vazkii.quark.misc.feature.AncientTomes;
import vazkii.quark.world.feature.Basalt;
import vazkii.quark.world.feature.Biotite;
import vazkii.quark.world.feature.RevampStoneGen;
import vazkii.quark.world.feature.UndergroundBiomes;

class ThermalExpansionQuarkIntegration
implements IThermalExpansionIntegration {
    ThermalExpansionQuarkIntegration() {
    }

    @Override
    public void addRecipes() {
        if (QuarkUtils.isFeatureEnabled(PistonSpikes.class)) {
            SmelterManager.addRecycleRecipe((int)8000, (ItemStack)new ItemStack(PistonSpikes.iron_rod), (ItemStack)new ItemStack(Items.field_151042_j), (int)1);
        }
        if (QuarkUtils.isFeatureEnabled(Trowel.class)) {
            SmelterManager.addRecycleRecipe((int)8000, (ItemStack)new ItemStack(Trowel.trowel), (ItemStack)new ItemStack(Items.field_151042_j), (int)1);
        }
        if (QuarkUtils.isFeatureEnabled(Grate.class)) {
            SmelterManager.addRecycleRecipe((int)8000, (ItemStack)new ItemStack(Grate.grate), (ItemStack)new ItemStack(Items.field_191525_da), (int)12);
        }
        if (QuarkUtils.isFeatureEnabled(ChainLinkage.class)) {
            SmelterManager.addRecycleRecipe((int)8000, (ItemStack)new ItemStack(ChainLinkage.chain), (ItemStack)new ItemStack(Items.field_191525_da), (int)7);
        }
        if (QuarkUtils.isFeatureEnabled(MetalButtons.class)) {
            if (MetalButtons.enableGold) {
                SmelterManager.addRecycleRecipe((int)8000, (ItemStack)new ItemStack(MetalButtons.gold_button), (ItemStack)new ItemStack(Items.field_151043_k), (int)1);
            }
            if (MetalButtons.enableIron) {
                SmelterManager.addRecycleRecipe((int)8000, (ItemStack)new ItemStack(MetalButtons.iron_button), (ItemStack)new ItemStack(Items.field_151042_j), (int)1);
            }
        }
        if (QuarkUtils.isFeatureEnabled(Biotite.class)) {
            FactorizerManager.addDefaultRecipe((ItemStack)new ItemStack(Biotite.biotite), (ItemStack)new ItemStack(Biotite.biotite_block), (int)4);
            PulverizerManager.addRecipe((int)3000, (ItemStack)new ItemStack(Biotite.biotite_block, 1, 2), (ItemStack)new ItemStack(Biotite.biotite));
        }
        if (QuarkUtils.isFeatureEnabled(SoulSandstone.class)) {
            for (int meta = 1; meta <= 2; ++meta) {
                PulverizerManager.addRecipe((int)3000, (ItemStack)new ItemStack((Block)SoulSandstone.soul_sandstone, 1, meta), (ItemStack)new ItemStack(Blocks.field_150425_aM), (ItemStack)ItemMaterial.dustSulfur, (int)40);
            }
        }
        if (QuarkUtils.isFeatureEnabled(UndergroundBiomes.class)) {
            if (UndergroundBiomes.firestoneEnabled) {
                CrucibleManager.addRecipe((int)40000, (ItemStack)new ItemStack((Block)UndergroundBiomes.biome_cobblestone, 1, 0), (FluidStack)new FluidStack(FluidRegistry.LAVA, 1000));
            }
            if (UndergroundBiomes.icystoneEnabled) {
                CrucibleManager.addRecipe((int)1600, (ItemStack)new ItemStack((Block)UndergroundBiomes.biome_cobblestone, 1, 1), (FluidStack)new FluidStack(FluidRegistry.WATER, 1000));
            }
        }
        if (QuarkUtils.isFeatureEnabled(Basalt.class)) {
            ExtruderManager.addRecipeIgneous((int)800, (ItemStack)new ItemStack((Block)Basalt.basalt), (FluidStack)new FluidStack(FluidRegistry.LAVA, 0), (FluidStack)new FluidStack(FluidRegistry.WATER, 1000));
        }
        if (QuarkUtils.isFeatureEnabled(RevampStoneGen.class)) {
            if (RevampStoneGen.enableMarble) {
                ExtruderManager.addRecipeIgneous((int)800, (ItemStack)new ItemStack((Block)RevampStoneGen.marble), (FluidStack)new FluidStack(FluidRegistry.LAVA, 0), (FluidStack)new FluidStack(FluidRegistry.WATER, 1000));
            }
            if (RevampStoneGen.enableSlate) {
                ExtruderManager.addRecipeIgneous((int)800, (ItemStack)new ItemStack((Block)RevampStoneGen.slate), (FluidStack)new FluidStack(FluidRegistry.LAVA, 0), (FluidStack)new FluidStack(FluidRegistry.WATER, 1000));
            }
            if (RevampStoneGen.enableLimestone) {
                ExtruderManager.addRecipeSedimentary((int)6400, (ItemStack)new ItemStack((Block)RevampStoneGen.limestone), (FluidStack)new FluidStack(FluidRegistry.LAVA, 0), (FluidStack)new FluidStack(FluidRegistry.WATER, 2000));
            }
            if (RevampStoneGen.enableJasper) {
                ExtruderManager.addRecipeSedimentary((int)6400, (ItemStack)new ItemStack((Block)RevampStoneGen.jasper), (FluidStack)new FluidStack(FluidRegistry.LAVA, 0), (FluidStack)new FluidStack(FluidRegistry.WATER, 2000));
            }
        }
    }

    @Override
    public void addPostInitRecipes() {
        if (QuarkConfiguration.ancientTomesCrafting && AncientTomes.ancient_tome != null) {
            EnchanterManager.EnchanterRecipe[] recipes;
            for (EnchanterManager.EnchanterRecipe recipe : recipes = EnchanterManager.getRecipeList()) {
                Optional<Enchantment> result = AncientTomes.validEnchants.stream().filter(enchant -> {
                    ResourceLocation name = enchant.getRegistryName();
                    return name != null && name.toString().equals(recipe.getEnchantName());
                }).findAny();
                if (!result.isPresent()) continue;
                Enchantment enchantment = result.get();
                ItemStack baseBook = ItemEnchantedBook.func_92111_a((EnchantmentData)new EnchantmentData(enchantment, 1));
                ItemStack ancientTome = new ItemStack(AncientTomes.ancient_tome);
                ItemEnchantedBook.func_92115_a((ItemStack)ancientTome, (EnchantmentData)new EnchantmentData(enchantment, enchantment.func_77325_b()));
                if (!baseBook.func_77942_o() || !ancientTome.func_77942_o()) continue;
                EnchanterManager.addRecipe((int)(recipe.getEnergy() * 10), (ItemStack)baseBook, (ItemStack)new ItemStack(recipe.getSecondaryInput().func_77973_b(), recipe.getSecondaryInput().func_77976_d()), (ItemStack)ancientTome, (int)10000, (EnchanterManager.Type)EnchanterManager.Type.STANDARD);
            }
        }
    }

    @Override
    @Nonnull
    public ModIds getModId() {
        return ModIds.QUARK;
    }
}

