/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.tconstruct;

import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.config.MiaConfig;
import com.github.sokyranthedragon.mia.config.TConstructConfiguration;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.base.IBaseMod;
import com.github.sokyranthedragon.mia.integrations.base.IModIntegration;
import com.github.sokyranthedragon.mia.integrations.tconstruct.ChiselTConstructIntegration;
import com.github.sokyranthedragon.mia.integrations.tconstruct.DungeonTacticsTConstructIntegration;
import com.github.sokyranthedragon.mia.integrations.tconstruct.ExtraUtilsTConstructIntegration;
import com.github.sokyranthedragon.mia.integrations.tconstruct.FutureMcTConstructIntegration;
import com.github.sokyranthedragon.mia.integrations.tconstruct.HatcheryTConstructIntegration;
import com.github.sokyranthedragon.mia.integrations.tconstruct.ITConstructIntegration;
import com.github.sokyranthedragon.mia.integrations.tconstruct.JerTConstructIntegration;
import com.github.sokyranthedragon.mia.integrations.tconstruct.ThermalExpansionTConstructIntegration;
import com.github.sokyranthedragon.mia.integrations.tconstruct.book.TinkersBook;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;

public class TinkersConstruct
implements IBaseMod {
    private List<ITConstructIntegration> modIntegrations = new LinkedList<ITConstructIntegration>();

    @Override
    public void addIntegration(IModIntegration integration) {
        if (!TConstructConfiguration.externalIntegrationsEnabled) {
            return;
        }
        if (integration instanceof ITConstructIntegration) {
            this.modIntegrations.add((ITConstructIntegration)integration);
            return;
        }
        Mia.LOGGER.warn("Incorrect TConstruct integration with id of " + (Object)((Object)integration.getModId()) + ": " + integration.toString());
    }

    @Override
    public void register(BiConsumer<ModIds, IModIntegration> modIntegration) {
        if (TConstructConfiguration.enableXu2Integration && ModIds.EXTRA_UTILITIES.isLoaded) {
            modIntegration.accept(ModIds.EXTRA_UTILITIES, new ExtraUtilsTConstructIntegration());
        }
        if (TConstructConfiguration.enableJerIntegration && ModIds.JER.isLoaded) {
            modIntegration.accept(ModIds.JER, new JerTConstructIntegration());
        }
        if (TConstructConfiguration.enableTeIntegration && ModIds.THERMAL_EXPANSION.isLoaded) {
            modIntegration.accept(ModIds.THERMAL_EXPANSION, new ThermalExpansionTConstructIntegration());
        }
        if (TConstructConfiguration.enableDungeonTacticsIntegration && ModIds.DUNGEON_TACTICS.isLoaded) {
            modIntegration.accept(ModIds.DUNGEON_TACTICS, new DungeonTacticsTConstructIntegration());
        }
        if (ModIds.HATCHERY.isLoaded) {
            modIntegration.accept(ModIds.HATCHERY, new HatcheryTConstructIntegration(TConstructConfiguration.enableHatcheryIntegration));
        }
        if (TConstructConfiguration.enableFutureMcIntegration && ModIds.FUTURE_MC.isLoaded) {
            modIntegration.accept(ModIds.FUTURE_MC, new FutureMcTConstructIntegration());
        }
        if (TConstructConfiguration.enableChiselIntegration && ModIds.CHISEL.isLoaded) {
            modIntegration.accept(ModIds.CHISEL, new ChiselTConstructIntegration());
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        Fluid fluid;
        if (TConstructConfiguration.tconstructAdditionsEnabled && !MiaConfig.disableAllRecipes && (fluid = FluidRegistry.getFluid((String)"iron")) != null) {
            TinkerRegistry.registerMelting((MeltingRecipe)new MeltingRecipe(RecipeMatch.of((Item)Items.field_151020_U, (int)320), fluid));
            TinkerRegistry.registerMelting((MeltingRecipe)new MeltingRecipe(RecipeMatch.of((Item)Items.field_151023_V, (int)512), fluid));
            TinkerRegistry.registerMelting((MeltingRecipe)new MeltingRecipe(RecipeMatch.of((Item)Items.field_151022_W, (int)448), fluid));
            TinkerRegistry.registerMelting((MeltingRecipe)new MeltingRecipe(RecipeMatch.of((Item)Items.field_151029_X, (int)256), fluid));
        }
        if (!this.modIntegrations.isEmpty()) {
            ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"ThermalExpansion init", (int)this.modIntegrations.size());
            ArrayList<String> modifiersToAdd = null;
            if (event.getSide() == Side.CLIENT) {
                modifiersToAdd = new ArrayList<String>();
            }
            for (ITConstructIntegration integration : this.modIntegrations) {
                progressBar.step(integration.getModId().modId);
                integration.init(event);
                if (event.getSide() != Side.CLIENT) continue;
                assert (modifiersToAdd != null);
                Collections.addAll(modifiersToAdd, integration.registerBookPages());
            }
            if (event.getSide() == Side.CLIENT) {
                assert (modifiersToAdd != null);
                if (modifiersToAdd.size() > 0) {
                    TinkersBook.registerBookPages(modifiersToAdd);
                }
            }
            ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        }
    }
}

