/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.thaumcraft.foci;

import com.github.sokyranthedragon.mia.potions.ModPotions;
import com.github.sokyranthedragon.mia.utilities.size.SizeUtils;
import javax.annotation.Nullable;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusEffect;
import thaumcraft.api.casters.NodeSetting;
import thaumcraft.api.casters.Trajectory;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXGeneric;

public class FocusEffectSizeSteal
extends FocusEffect {
    public boolean execute(RayTraceResult rayTraceResult, @Nullable Trajectory trajectory, float v, int i) {
        if (!SizeUtils.isSizeComponentEnabled) {
            return false;
        }
        if (rayTraceResult.field_72313_a == RayTraceResult.Type.ENTITY && rayTraceResult.field_72308_g instanceof EntityLivingBase) {
            EntityLivingBase caster = this.getPackage().getCaster();
            EntityLivingBase target = (EntityLivingBase)rayTraceResult.field_72308_g;
            if (caster instanceof FakePlayer || caster == target || !SizeUtils.canEntityBeScaled(target)) {
                return false;
            }
            target.func_70690_d(new PotionEffect(ModPotions.shrinkingPotion, 20, 0));
            caster.func_70690_d(new PotionEffect(ModPotions.growthPotion, 20, 0));
        }
        return false;
    }

    public NodeSetting[] createSettings() {
        return new NodeSetting[]{new NodeSetting("power", "focus.common.power", (NodeSetting.INodeSettingType)new NodeSetting.NodeSettingIntRange(1, 2))};
    }

    public void onCast(Entity caster) {
        caster.field_70170_p.func_184133_a(null, caster.func_180425_c().func_177984_a(), SoundEvents.field_190021_aL, SoundCategory.PLAYERS, 0.2f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderParticleFX(World world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        FXGeneric fx = new FXGeneric(world, x, y, z, motionX + world.field_73012_v.nextGaussian() * (double)0.01f, motionY + world.field_73012_v.nextGaussian() * (double)0.01f, motionZ + world.field_73012_v.nextGaussian() * (double)0.01f);
        fx.func_187114_a(10 + world.field_73012_v.nextInt(10));
        fx.func_70538_b(0.8f, 0.8f, 0.8f);
        fx.setGravity(0.01f);
        fx.setParticles(4, 16, 4);
        fx.setRandomMovementScale(0.0125f, 0.0125f, 0.0125f);
        fx.setGridSize(32);
        fx.setRotationSpeed(world.field_73012_v.nextFloat(), 0.0f);
        fx.setLoop(false);
        ParticleEngine.addEffect((World)world, (Particle)fx);
    }

    public int getComplexity() {
        return this.getSettingValue("power") * 10 + 5;
    }

    public Aspect getAspect() {
        return Aspect.MAGIC;
    }

    public String getKey() {
        return "mia.focus.size_steal";
    }

    public String getResearch() {
        return "MIA.FOCUS_SIZE_STEAL@2";
    }
}

