/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.integrations.xu2;

import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.config.Xu2Configuration;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.integrations.jer.IJerIntegration;
import com.github.sokyranthedragon.mia.integrations.jer.custom.CustomPlantEntry;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.blocks.BlockEnderLilly;
import com.rwtema.extrautils2.blocks.BlockRedOrchid;
import com.rwtema.extrautils2.villagers.XUVillagerCareer;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import jeresources.api.IPlantRegistry;
import jeresources.api.drop.PlantDrop;
import jeresources.entry.PlantEntry;
import jeresources.entry.VillagerEntry;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.registries.GameData;

@ParametersAreNonnullByDefault
class JerExtraUtilsIntegration
implements IJerIntegration {
    JerExtraUtilsIntegration() {
    }

    @Override
    public void addPlantDrops(IPlantRegistry plantRegistry, @Nullable Collection<PlantEntry> registers) {
        if (registers != null) {
            CustomPlantEntry redOrchid = new CustomPlantEntry(XU2Entries.blockRedOrchid.newStack(), (IPlantable)XU2Entries.blockRedOrchid.value, (IProperty<?>)BlockRedOrchid.GROWTH_STATE, new PlantDrop(XU2Entries.blockRedOrchid.newStack(), 1, 1), new PlantDrop(new ItemStack(Items.field_151137_ax), 1, 3));
            redOrchid.setSoil(Blocks.field_150450_ax.func_176223_P());
            registers.add(redOrchid);
            CustomPlantEntry enderLilly = new CustomPlantEntry(XU2Entries.blockEnderLilly.newStack(), (IPlantable)XU2Entries.blockEnderLilly.value, (IProperty<?>)BlockEnderLilly.GROWTH_STATE, new PlantDrop(XU2Entries.blockEnderLilly.newStack(), 1, 1), new PlantDrop(new ItemStack(Items.field_151079_bi), 1, 2));
            enderLilly.setSoil(Blocks.field_150377_bs.func_176223_P());
            registers.add(enderLilly);
        } else {
            plantRegistry.registerWithSoil(XU2Entries.blockEnderLilly.newStack(), Blocks.field_150377_bs.func_176223_P(), new PlantDrop[]{new PlantDrop(XU2Entries.blockEnderLilly.newStack(), 1, 1), new PlantDrop(new ItemStack(Items.field_151079_bi), 1, 2)});
            plantRegistry.registerWithSoil(XU2Entries.blockRedOrchid.newStack(), Blocks.field_150450_ax.func_176223_P(), new PlantDrop[]{new PlantDrop(XU2Entries.blockRedOrchid.newStack(), 1, 1), new PlantDrop(new ItemStack(Items.field_151137_ax), 1, 3)});
        }
    }

    @Override
    public void overrideExistingVillagerTrades(VillagerEntry villagerEntry) {
        try {
            RegistryNamespaced wrapper = GameData.getWrapper(VillagerRegistry.VillagerProfession.class);
            Field randomLists = XUVillagerCareer.class.getDeclaredField("randomLists");
            Field detLists = XUVillagerCareer.class.getDeclaredField("detLists");
            randomLists.setAccessible(true);
            detLists.setAccessible(true);
            VillagerRegistry.VillagerProfession profession = (VillagerRegistry.VillagerProfession)wrapper.func_148754_a(villagerEntry.getProfession());
            if (profession == null || profession.getRegistryName() == null || !profession.getRegistryName().func_110624_b().equals(ModIds.EXTRA_UTILITIES.modId)) {
                return;
            }
            VillagerRegistry.VillagerCareer career = profession.getCareer(villagerEntry.getCareer());
            TIntObjectHashMap tradeList = null;
            switch (villagerEntry.getName()) {
                case "alchemist": {
                    tradeList = (TIntObjectHashMap)detLists.get(career);
                    break;
                }
                case "red_mechanic": {
                    tradeList = (TIntObjectHashMap)randomLists.get(career);
                    break;
                }
                case "shady_merchant": {
                    if (!Xu2Configuration.enableShadyMerchantJer) break;
                    tradeList = (TIntObjectHashMap)randomLists.get(career);
                }
            }
            if (tradeList != null) {
                villagerEntry.addITradeLists(new ArrayList(tradeList.valueCollection()));
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Mia.LOGGER.error("Could not add villager trades for ExtraUtils", (Throwable)e);
        }
    }

    @Override
    @Nonnull
    public ModIds getModId() {
        return ModIds.EXTRA_UTILITIES;
    }
}

