/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.network;

import com.github.sokyranthedragon.mia.utilities.size.SizeUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageExtendedReachAttack
implements IMessage {
    private int entityId;

    public MessageExtendedReachAttack() {
    }

    public MessageExtendedReachAttack(int entityId) {
        this.entityId = entityId;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = ByteBufUtils.readVarInt((ByteBuf)buf, (int)4);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.entityId, (int)4);
    }

    public static class Handler
    implements IMessageHandler<MessageExtendedReachAttack, IMessage> {
        public IMessage onMessage(MessageExtendedReachAttack message, MessageContext context) {
            EntityPlayerMP player = context.getServerHandler().field_147369_b;
            player.func_71121_q().func_152344_a(() -> {
                double tempDistance;
                Entity entity = player.field_70170_p.func_73045_a(message.entityId);
                if (entity == null) {
                    return;
                }
                float size = SizeUtils.getEntitySize((EntityLivingBase)player);
                double distanceSquared = 36.0;
                if (size > 1.0f && (tempDistance = (double)(3.0f * size)) > 6.0) {
                    distanceSquared = tempDistance * tempDistance;
                }
                if (!player.func_70685_l(entity)) {
                    distanceSquared /= 4.0;
                }
                if (player.func_70068_e(entity) < distanceSquared) {
                    if (entity instanceof EntityItem || entity instanceof EntityXPOrb || entity instanceof EntityArrow || entity == player) {
                        return;
                    }
                    player.func_71059_n(entity);
                }
            });
            return null;
        }
    }
}

