/*
 * Decompiled with CFR 0.152.
 */
package com.github.sokyranthedragon.mia.utilities;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import com.github.sokyranthedragon.mia.Mia;
import com.github.sokyranthedragon.mia.capabilities.MusicPlayerCapabilityProvider;
import com.github.sokyranthedragon.mia.config.MiaConfig;
import com.github.sokyranthedragon.mia.handlers.MusicPlayerStackHandler;
import com.github.sokyranthedragon.mia.integrations.ModIds;
import com.github.sokyranthedragon.mia.network.MessageSyncMusicPlayer;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ISoundEventListener;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.mutable.MutableInt;

@SideOnly(value=Side.CLIENT)
@ParametersAreNonnullByDefault
public class MusicUtils {
    public static SoundEffectListener listener = new SoundEffectListener();
    public static Map<UUID, PositionedSoundRecord> currentlyPlayedSongs = new HashMap<UUID, PositionedSoundRecord>();

    private MusicUtils() {
    }

    public static void toggleSong(MusicPlayerStackHandler musicPlayer) {
        if (!listener.startedPlaying(musicPlayer.itemUuid)) {
            return;
        }
        SoundHandler soundHandler = Minecraft.func_71410_x().func_147118_V();
        PositionedSoundRecord currentSong = currentlyPlayedSongs.remove(musicPlayer.itemUuid);
        if (currentSong != null && soundHandler.func_147692_c((ISound)currentSong)) {
            soundHandler.func_147683_b((ISound)currentSong);
        } else {
            if (currentSong != null) {
                soundHandler.func_147683_b((ISound)currentSong);
            }
            MusicUtils.playSong(musicPlayer, soundHandler);
        }
    }

    public static void playSong(MusicPlayerStackHandler musicPlayer) {
        if (!listener.startedPlaying(musicPlayer.itemUuid)) {
            return;
        }
        SoundHandler soundHandler = Minecraft.func_71410_x().func_147118_V();
        MusicUtils.stopSong(musicPlayer, soundHandler);
        MusicUtils.playSong(musicPlayer, soundHandler);
    }

    private static void playSong(MusicPlayerStackHandler musicPlayer, SoundHandler soundHandler) {
        if (!MusicUtils.isMusicOn()) {
            Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TextComponentTranslation("mia.gui.music_player.tooltip.sound_off", new Object[0]), false);
            return;
        }
        ItemStack item = musicPlayer.getCurrentSong();
        if (!item.func_190926_b() && item.func_77973_b() instanceof ItemRecord) {
            ItemRecord record = (ItemRecord)item.func_77973_b();
            PositionedSoundRecord currentSong = new PositionedSoundRecord(record.func_185075_h().func_187503_a(), SoundCategory.MASTER, 4.0f * (float)MiaConfig.musicPlayerVolume / 100.0f, 1.0f, false, 0, ISound.AttenuationType.NONE, 0.0f, 0.0f, 0.0f);
            listener.addListener(musicPlayer.itemUuid, (ISound)currentSong);
            currentlyPlayedSongs.put(musicPlayer.itemUuid, currentSong);
            soundHandler.func_147682_a((ISound)currentSong);
            Minecraft.func_71410_x().field_71456_v.func_73833_a(record.func_150927_i());
        }
    }

    public static void stopSong(MusicPlayerStackHandler musicPlayer) {
        MusicUtils.stopSong(musicPlayer, Minecraft.func_71410_x().func_147118_V());
    }

    private static void stopSong(MusicPlayerStackHandler musicPlayer, SoundHandler soundHandler) {
        PositionedSoundRecord currentSong = currentlyPlayedSongs.remove(musicPlayer.itemUuid);
        if (currentSong != null) {
            soundHandler.func_147683_b((ISound)currentSong);
        }
    }

    public static void playNext(MusicPlayerStackHandler musicPlayer) {
        if (musicPlayer.getSlots() > 0 && listener.startedPlaying(musicPlayer.itemUuid)) {
            ItemStack currentSong = musicPlayer.getCurrentSong();
            if (currentSong.func_190926_b()) {
                musicPlayer.setCurrentSongSlot(0);
            } else {
                musicPlayer.nextSong();
            }
            MusicUtils.playSong(musicPlayer);
        }
    }

    public static void playPrevious(MusicPlayerStackHandler musicPlayer) {
        if (musicPlayer.getSlots() > 0 && listener.startedPlaying(musicPlayer.itemUuid)) {
            ItemStack currentSong = musicPlayer.getCurrentSong();
            if (currentSong.func_190926_b()) {
                musicPlayer.setCurrentSongSlot(0);
            } else {
                musicPlayer.previousSong();
            }
            MusicUtils.playSong(musicPlayer);
        }
    }

    public static void randomNext(MusicPlayerStackHandler musicPlayer) {
        int slots = musicPlayer.getSlots();
        if (slots >= 1) {
            if (slots >= 2) {
                int newSlot = Minecraft.func_71410_x().field_71441_e.field_73012_v.nextInt(slots - 1);
                if (newSlot == musicPlayer.getCurrentSongSlot()) {
                    ++newSlot;
                }
                musicPlayer.setCurrentSongSlot(newSlot);
            }
            MusicUtils.playSong(musicPlayer);
        }
    }

    public static void updateMusicPlayerWithUuid(EntityPlayer player, MusicPlayerStackHandler musicPlayer) {
        if (ModIds.BAUBLES.isLoaded) {
            IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int i = 0; i < baubles.getSlots(); ++i) {
                ItemStack stack = baubles.getStackInSlot(i);
                MusicPlayerStackHandler capability = (MusicPlayerStackHandler)stack.getCapability(MusicPlayerCapabilityProvider.ITEM_HANDLER_CAPABILITY, null);
                if (capability == null || !capability.itemUuid.equals(musicPlayer.itemUuid)) continue;
                Mia.network.sendToServer((IMessage)new MessageSyncMusicPlayer(3, i, musicPlayer, false));
                return;
            }
        }
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            MusicPlayerStackHandler capability = (MusicPlayerStackHandler)stack.getCapability(MusicPlayerCapabilityProvider.ITEM_HANDLER_CAPABILITY, null);
            if (capability == null || !capability.itemUuid.equals(musicPlayer.itemUuid)) continue;
            Mia.network.sendToServer((IMessage)new MessageSyncMusicPlayer(2, i, musicPlayer, false));
            return;
        }
        MusicPlayerStackHandler capability = (MusicPlayerStackHandler)player.func_184592_cb().getCapability(MusicPlayerCapabilityProvider.ITEM_HANDLER_CAPABILITY, null);
        if (capability != null && capability.itemUuid.equals(musicPlayer.itemUuid)) {
            Mia.network.sendToServer((IMessage)new MessageSyncMusicPlayer(1, 0, musicPlayer, false));
        }
    }

    public static boolean isMusicOn() {
        return MiaConfig.musicPlayerVolume > 0 && Minecraft.func_71410_x().field_71474_y.func_186711_a(SoundCategory.MASTER) > 0.0f;
    }

    static {
        Minecraft.func_71410_x().func_147118_V().func_184402_a((ISoundEventListener)listener);
    }

    public static class SoundEffectListener
    implements ISoundEventListener {
        private BiMap<ISound, UUID> listeners = HashBiMap.create();
        private Map<UUID, MutableInt> timers = new HashMap<UUID, MutableInt>();

        private SoundEffectListener() {
        }

        public void func_184067_a(ISound sound, SoundEventAccessor soundEventAccessor) {
            UUID removed = (UUID)this.listeners.remove((Object)sound);
            this.timers.put(removed, new MutableInt(5));
        }

        public void updateTimers() {
            this.timers = this.timers.entrySet().stream().filter(timer -> ((MutableInt)timer.getValue()).decrementAndGet() > 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        public void addListener(UUID id, ISound sound) {
            this.listeners.put((Object)sound, (Object)id);
        }

        public boolean startedPlaying(UUID id) {
            return !this.listeners.inverse().containsKey((Object)id) && !this.timers.containsKey(id);
        }
    }
}

