/*
 * Decompiled with CFR 0.152.
 */
package com.keletu.advanced_smelter.tile;

import com.keletu.advanced_smelter.AdvancedEssentiaSmelterMod;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.AspectHelper;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;
import thaumcraft.common.tiles.TileThaumcraft;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.impetus.node.CapabilityImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.ConsumeResult;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.NodeHelper;
import thecodex6824.thaumicaugmentation.api.impetus.node.prefab.SimpleImpetusConsumer;
import thecodex6824.thaumicaugmentation.api.util.DimensionalBlockPos;

public class TileAlchemicalSmelterAdvanced
extends TileThaumcraft
implements ITickable {
    public AspectList aspects = new AspectList();
    public int vis;
    public int maxVis = AdvancedEssentiaSmelterMod.AAFConfig.MAXIMUM;
    public int power1 = 0;
    public int maxPower = AdvancedEssentiaSmelterMod.AAFConfig.MAXIMUM;
    public int heat = 0;
    public boolean destroy = false;
    int count = 0;
    int processed = 0;
    protected SimpleImpetusConsumer node = new SimpleImpetusConsumer(1, 0);
    private int ticks = ThreadLocalRandom.current().nextInt(20);

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 1), (double)this.func_174877_v().func_177956_o(), (double)(this.func_174877_v().func_177952_p() - 1), (double)(this.func_174877_v().func_177958_n() + 2), (double)(this.func_174877_v().func_177956_o() + 2), (double)(this.func_174877_v().func_177952_p() + 2));
    }

    public void readSyncNBT(NBTTagCompound nbttagcompound) {
        this.vis = nbttagcompound.func_74765_d("vis");
        this.heat = nbttagcompound.func_74765_d("heat");
    }

    public NBTTagCompound writeSyncNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74777_a("vis", (short)this.vis);
        nbttagcompound.func_74777_a("heat", (short)this.heat);
        nbttagcompound.func_74782_a("node", (NBTBase)this.node.serializeNBT());
        return nbttagcompound;
    }

    public void func_145839_a(NBTTagCompound nbtCompound) {
        super.func_145839_a(nbtCompound);
        this.aspects.readFromNBT(nbtCompound);
        this.node.deserializeNBT(nbtCompound.func_74775_l("node"));
        this.power1 = nbtCompound.func_74765_d("power1");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbtCompound) {
        super.func_189515_b(nbtCompound);
        this.aspects.writeToNBT(nbtCompound);
        nbtCompound.func_74782_a("node", (NBTBase)this.node.serializeNBT());
        nbtCompound.func_74777_a("power1", (short)this.power1);
        return nbtCompound;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.node.init(this.field_145850_b);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        if (this.field_145850_b != null) {
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.func_174877_v());
        }
    }

    public void func_73660_a() {
        ++this.count;
        if (!this.field_145850_b.field_72995_K) {
            if (this.destroy) {
                for (int a = -1; a <= 1; ++a) {
                    for (int b = 0; b <= 1; ++b) {
                        for (int c = -1; c <= 1; ++c) {
                            if (a == 0 && b == 0 && c == 0 || this.field_145850_b.func_180495_p(new BlockPos(this.func_174877_v().func_177958_n() + a, this.func_174877_v().func_177956_o() + b, this.func_174877_v().func_177952_p() + c)).func_177230_c() != this.func_145838_q()) continue;
                            IBlockState m = this.field_145850_b.func_180495_p(new BlockPos(this.func_174877_v().func_177958_n() + a, this.func_174877_v().func_177956_o() + b, this.func_174877_v().func_177952_p() + c));
                            this.field_145850_b.func_180501_a(new BlockPos((Vec3i)this.func_174877_v().func_177982_a(a, b, c)), Block.func_149634_a((Item)this.func_145838_q().func_180660_a(m, this.field_145850_b.field_73012_v, 0)).func_176203_a(this.func_145838_q().func_180651_a(m)), 3);
                        }
                    }
                }
                this.field_145850_b.func_180501_a(this.func_174877_v(), Block.func_149634_a((Item)this.func_145838_q().func_180660_a(this.func_145838_q().func_176223_P(), this.field_145850_b.field_73012_v, 0)).func_176223_P(), 3);
                return;
            }
            if (this.processed > 0) {
                --this.processed;
            }
            if (this.count % 5 == 0) {
                int pt = this.heat--;
                if (this.heat <= this.maxPower) {
                    this.heat = (int)((float)this.heat + AuraHelper.drainVis((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (float)0.5f, (boolean)false) * 20.0f);
                }
                if (this.power1 <= this.maxPower && this.ticks++ % 10 == 0) {
                    if (this.ticks % 20 == 0) {
                        NodeHelper.validate((IImpetusNode)this.node, (World)this.field_145850_b);
                    }
                    ConsumeResult result = this.node.consume(1L, false);
                    if (result.energyConsumed == 1L) {
                        this.power1 = (int)((long)this.power1 + result.energyConsumed * (long)AdvancedEssentiaSmelterMod.AAFConfig.EFFICIENCY);
                        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 6);
                        this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 1, 0);
                        NodeHelper.syncAllImpetusTransactions(result.paths.keySet());
                        for (Map.Entry entry : result.paths.entrySet()) {
                            NodeHelper.damageEntitiesFromTransaction((Deque)((Deque)entry.getKey()), (long)((Long)entry.getValue()));
                        }
                    }
                }
                if (pt / 50 != this.heat / 50) {
                    IBlockState block = this.func_145831_w().func_180495_p(this.func_174877_v());
                    this.field_145850_b.func_184138_a(this.func_174877_v(), block, block, 3);
                }
            }
        }
    }

    public boolean process(ItemStack stack) {
        if (this.processed == 0 && this.canSmelt(stack)) {
            AspectList al = ThaumcraftCraftingManager.getObjectTags((ItemStack)stack);
            al = AspectHelper.getObjectAspects((ItemStack)stack);
            int aa = al.visSize();
            if (aa * 2 > this.heat || aa > this.power1) {
                return false;
            }
            this.heat -= aa * 2;
            this.power1 -= aa;
            this.processed = (int)((float)this.processed + (5.0f + Math.max(0.0f, (1.0f - (float)this.heat / (float)this.maxPower) * 100.0f)));
            this.aspects.add(al);
            this.vis = this.aspects.visSize();
            this.func_70296_d();
            this.field_145850_b.func_175625_s(this.func_174877_v());
            return true;
        }
        return false;
    }

    private boolean canSmelt(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        AspectList al = ThaumcraftCraftingManager.getObjectTags((ItemStack)stack);
        if (al == null) {
            return false;
        }
        if (al.size() == 0) {
            return false;
        }
        int vs = al.visSize();
        return vs + this.aspects.visSize() <= this.maxVis;
    }

    public void func_174878_a(BlockPos posIn) {
        super.func_174878_a(posIn);
        if (this.field_145850_b != null) {
            this.node.setLocation(new DimensionalBlockPos(this.field_174879_c.func_185334_h(), this.field_145850_b.field_73011_w.getDimension()));
        }
    }

    public void func_145834_a(World worldIn) {
        super.func_145834_a(worldIn);
        this.node.setLocation(new DimensionalBlockPos(this.field_174879_c.func_185334_h(), this.field_145850_b.field_73011_w.getDimension()));
    }

    public void onLoad() {
        this.node.init(this.field_145850_b);
        ThaumicAugmentation.proxy.registerRenderableImpetusNode((IImpetusNode)this.node);
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            NodeHelper.syncDestroyedImpetusNode((IImpetusNode)this.node);
        }
        this.node.destroy();
        ThaumicAugmentation.proxy.deregisterRenderableImpetusNode((IImpetusNode)this.node);
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.node.unload();
        ThaumicAugmentation.proxy.deregisterRenderableImpetusNode((IImpetusNode)this.node);
    }

    public boolean func_145842_c(int id, int type) {
        return true;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityImpetusNode.IMPETUS_NODE) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityImpetusNode.IMPETUS_NODE) {
            return (T)CapabilityImpetusNode.IMPETUS_NODE.cast((Object)this.node);
        }
        return (T)super.getCapability(capability, facing);
    }
}

