/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.cathedral.features.cathedral;

import com.ferreusveritas.cathedral.CathedralMod;
import com.ferreusveritas.cathedral.features.cathedral.EnumMaterial;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGargoyle
extends Block {
    public static final String name = "gargoyle";
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyEnum<EnumMount> MOUNT = PropertyEnum.func_177709_a((String)"mount", EnumMount.class);
    private EnumMaterial enumMaterial;

    public BlockGargoyle(EnumMaterial material) {
        this(name, material);
    }

    public BlockGargoyle(String name, EnumMaterial material) {
        super(Material.field_151576_e);
        this.enumMaterial = material;
        this.setRegistryName(name);
        this.func_149663_c(name);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(MOUNT, (Comparable)((Object)EnumMount.FLOOR)));
        this.func_149647_a(CathedralMod.tabCathedral);
        this.func_149711_c(1.0f);
        this.func_149752_b(3.0f);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, MOUNT});
    }

    public IBlockState func_176203_a(int meta) {
        int facingNum = meta & 3;
        int mountNum = meta >> 2 & 3;
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.field_176754_o[facingNum]).func_177226_a(MOUNT, (Comparable)((Object)EnumMount.values()[mountNum]));
    }

    public int func_176201_c(IBlockState state) {
        int facingNum = 0;
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                facingNum = 0;
                break;
            }
            case EAST: {
                facingNum = 1;
                break;
            }
            case SOUTH: {
                facingNum = 2;
                break;
            }
            case WEST: {
                facingNum = 3;
                break;
            }
            default: {
                facingNum = 0;
            }
        }
        return ((EnumMount)((Object)state.func_177229_b(MOUNT))).ordinal() << 2 | facingNum;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
        switch (facing) {
            case UP: {
                iblockstate = iblockstate.func_177226_a(MOUNT, (Comparable)((Object)EnumMount.FLOOR)).func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
                break;
            }
            case DOWN: {
                iblockstate = iblockstate.func_177226_a(MOUNT, (Comparable)((Object)EnumMount.CEILING)).func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
                break;
            }
            default: {
                iblockstate = iblockstate.func_177226_a(MOUNT, (Comparable)((Object)EnumMount.WALL)).func_177226_a((IProperty)FACING, (Comparable)facing);
            }
        }
        return iblockstate;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        IBlockState state = Blocks.field_150346_d.func_176223_P();
        ItemStack stack = this.enumMaterial.getRawMaterialBlock();
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block != Blocks.field_150350_a) {
            state = block.func_176223_P();
        }
        TextureAtlasSprite texture = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
        if (!state.func_177230_c().isAir(state, (IBlockAccess)world, pos)) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    for (int l = 0; l < 4; ++l) {
                        double d0 = ((double)j + 0.5) / 4.0;
                        double d1 = ((double)k + 0.5) / 4.0;
                        double d2 = ((double)l + 0.5) / 4.0;
                        ParticleDigging particle = (ParticleDigging)manager.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, d0 - 0.5, d1 - 0.5, d2 - 0.5, new int[]{Block.func_176210_f((IBlockState)state)});
                        if (particle == null) continue;
                        particle.func_187117_a(texture);
                        particle.func_174846_a(pos);
                    }
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return false;
    }

    public boolean addLandingEffects(IBlockState state, WorldServer worldObj, BlockPos blockPosition, IBlockState iblockstate, EntityLivingBase entity, int numberOfParticles) {
        ItemStack stack = this.enumMaterial.getRawMaterialBlock();
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (block != Blocks.field_150350_a) {
            state = block.func_176223_P();
        }
        worldObj.func_175739_a(EnumParticleTypes.BLOCK_DUST, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, numberOfParticles, 0.0, 0.0, 0.0, 0.15, new int[]{Block.func_176210_f((IBlockState)state)});
        return true;
    }

    public static enum EnumMount implements IStringSerializable
    {
        CEILING("ceiling"),
        WALL("wall"),
        FLOOR("floor"),
        FENCE("fence");

        String name;

        private EnumMount(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

