/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.cathedral.features.cathedral;

import com.ferreusveritas.cathedral.CathedralMod;
import com.ferreusveritas.cathedral.features.cathedral.EnumMaterial;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;

public class BlockPillar
extends Block {
    public static final String name = "pillar";
    public static final IUnlistedProperty[] CONNECTIONS = new IUnlistedProperty[]{new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)EnumFacing.DOWN.func_176610_l())), new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)EnumFacing.UP.func_176610_l())), new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)EnumFacing.NORTH.func_176610_l())), new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)EnumFacing.SOUTH.func_176610_l())), new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)EnumFacing.WEST.func_176610_l())), new Properties.PropertyAdapter((IProperty)PropertyBool.func_177716_a((String)EnumFacing.EAST.func_176610_l()))};

    public BlockPillar() {
        this(name);
    }

    public BlockPillar(String name) {
        super(Material.field_151576_e);
        this.setRegistryName(name);
        this.func_149663_c(name);
        this.func_180632_j(this.field_176227_L.func_177621_b());
        this.func_149647_a(CathedralMod.tabCathedral);
    }

    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{EnumMaterial.VARIANT};
        return new ExtendedBlockState((Block)this, listedProperties, CONNECTIONS);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(EnumMaterial.VARIANT, (Comparable)((Object)EnumMaterial.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumMaterial)((Object)state.func_177229_b(EnumMaterial.VARIANT))).getMetadata();
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState retval = (IExtendedBlockState)state;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                retval = retval.withProperty(CONNECTIONS[dir.func_176745_a()], (Object)this.canPillarConnectTo(world, pos, dir));
            }
            return retval;
        }
        return state;
    }

    private boolean canPillarConnectTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        BlockPos other = pos.func_177972_a(facing);
        Block block = world.func_180495_p(other).func_177230_c();
        if (block instanceof BlockPillar) {
            return true;
        }
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            return false;
        }
        return block.canBeConnectedTo(world, other, facing.func_176734_d()) || this.canConnectTo(world, other, facing.func_176734_d());
    }

    private boolean canConnectTo(IBlockAccess worldIn, BlockPos pos, EnumFacing facing) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        BlockFaceShape blockfaceshape = iblockstate.func_193401_d(worldIn, pos, facing);
        return !BlockPillar.isExceptionBlockForAttachWithPiston(block) && blockfaceshape == BlockFaceShape.SOLID;
    }

    protected static boolean isExceptionBlockForAttachWithPiston(Block block) {
        return Block.func_193382_c((Block)block) || block == Blocks.field_180401_cv || block == Blocks.field_150440_ba || block == Blocks.field_150423_aK || block == Blocks.field_150428_aP;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face.func_176740_k() == EnumFacing.Axis.Y ? BlockFaceShape.CENTER_BIG : BlockFaceShape.UNDEFINED;
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumMaterial)((Object)state.func_177229_b(EnumMaterial.VARIANT))).getMetadata();
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumMaterial type : EnumMaterial.values()) {
            items.add((Object)new ItemStack((Block)this, 1, type.getMetadata()));
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        return ((EnumMaterial)((Object)blockState.func_177229_b(EnumMaterial.VARIANT))).getHardness();
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return ((EnumMaterial)((Object)world.func_180495_p(pos).func_177229_b(EnumMaterial.VARIANT))).getExplosionResistance(exploder);
    }
}

