/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.cathedral.features.extras;

import com.ferreusveritas.cathedral.CathedralMod;
import com.ferreusveritas.cathedral.common.blocks.BlockMultiVariant;
import com.ferreusveritas.cathedral.common.blocks.BlockStairsGeneric;
import com.ferreusveritas.cathedral.features.BlockForm;
import com.ferreusveritas.cathedral.features.IFeature;
import com.ferreusveritas.cathedral.features.extras.BlockDoubleSlabEndstone;
import com.ferreusveritas.cathedral.features.extras.BlockSlabEndstone;
import com.ferreusveritas.cathedral.features.extras.FeatureTypes;
import com.ferreusveritas.cathedral.proxy.ModelHelper;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSlab;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Extras
implements IFeature {
    public static final String featureName = "extras";
    public Block blockStone;
    public Block blockEndstone;
    public Block slabEndstone;
    public Block slabEndstoneDouble;
    public ArrayList<Block> stairsEndstone = new ArrayList();

    @Override
    public String getName() {
        return featureName;
    }

    @Override
    public void preInit() {
    }

    @Override
    public void createBlocks() {
        this.blockStone = new BlockMultiVariant<FeatureTypes.EnumStoneType>(Material.field_151576_e, FeatureTypes.EnumStoneType.class, this.featureObjectName(BlockForm.BLOCK, "stone")){

            @Override
            public void makeVariantProperty() {
                this.variant = PropertyEnum.func_177709_a((String)"variant", FeatureTypes.EnumStoneType.class);
            }
        }.func_149647_a(CathedralMod.tabCathedral).func_149711_c(1.5f).func_149752_b(30.0f);
        this.blockEndstone = new BlockMultiVariant<FeatureTypes.EnumEndStoneType>(Material.field_151576_e, FeatureTypes.EnumEndStoneType.class, this.featureObjectName(BlockForm.BLOCK, "endstone")){

            @Override
            public void makeVariantProperty() {
                this.variant = PropertyEnum.func_177709_a((String)"variant", FeatureTypes.EnumEndStoneType.class);
            }
        }.func_149647_a(CathedralMod.tabCathedral).func_149711_c(3.0f).func_149752_b(45.0f);
        this.slabEndstone = new BlockSlabEndstone(this.featureObjectName(BlockForm.SLAB, "endstone")).func_149647_a(CathedralMod.tabCathedral).func_149711_c(3.0f).func_149752_b(45.0f);
        this.slabEndstoneDouble = new BlockDoubleSlabEndstone(this.featureObjectName(BlockForm.DOUBLESLAB, "endstone")).func_149647_a(CathedralMod.tabCathedral).func_149711_c(3.0f).func_149752_b(45.0f);
        for (FeatureTypes.EnumEndStoneSlabType type : FeatureTypes.EnumEndStoneSlabType.values()) {
            this.stairsEndstone.add(new BlockStairsGeneric(this.featureObjectName(BlockForm.STAIRS, "endstone_" + type.func_176610_l()), this.blockEndstone.func_176223_P()).func_149647_a(CathedralMod.tabCathedral));
        }
    }

    @Override
    public void createItems() {
    }

    @Override
    public void registerBlocks(IForgeRegistry<Block> registry) {
        registry.registerAll((IForgeRegistryEntry[])new Block[]{this.blockStone, this.blockEndstone, this.slabEndstone, this.slabEndstoneDouble});
        registry.registerAll((IForgeRegistryEntry[])this.stairsEndstone.toArray(new Block[0]));
    }

    @Override
    public void registerItems(IForgeRegistry<Item> registry) {
        registry.register((IForgeRegistryEntry)((BlockMultiVariant)this.blockStone).getItemMultiTexture());
        registry.register((IForgeRegistryEntry)((BlockMultiVariant)this.blockEndstone).getItemMultiTexture());
        ItemSlab itemSlabEndstone = new ItemSlab(this.slabEndstone, (BlockSlab)this.slabEndstone, (BlockSlab)this.slabEndstoneDouble);
        itemSlabEndstone.setRegistryName(this.slabEndstone.getRegistryName());
        registry.register((IForgeRegistryEntry)itemSlabEndstone);
        for (FeatureTypes.EnumEndStoneSlabType type : FeatureTypes.EnumEndStoneSlabType.values()) {
            registry.register(new ItemBlock(this.stairsEndstone.get(type.ordinal())).setRegistryName(this.stairsEndstone.get(type.ordinal()).getRegistryName()));
        }
    }

    private void tryRegisterBlockOre(String oreName, ItemStack ore) {
        if (!ore.func_190926_b()) {
            OreDictionary.registerOre((String)oreName, (ItemStack)ore);
        }
    }

    public static ItemStack getRawEndstone() {
        return new ItemStack(Blocks.field_150377_bs);
    }

    @Override
    public void registerRecipes(IForgeRegistry<IRecipe> registry) {
        String endstoneOre = "blockEndstone";
        this.tryRegisterBlockOre(endstoneOre, Extras.getRawEndstone());
        for (FeatureTypes.EnumEndStoneSlabType type : FeatureTypes.EnumEndStoneSlabType.values()) {
            Block baseBlock = (Block)Block.field_149771_c.func_82594_a((Object)type.getBaseResourceLocation());
            if (baseBlock == Blocks.field_150350_a) continue;
            ItemStack baseItemBlock = new ItemStack(baseBlock, 1, type.getBaseMeta());
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("cathedral", this.slabEndstone.getRegistryName().func_110623_a() + "." + type.getUnlocalizedName()), null, (ItemStack)new ItemStack(this.slabEndstone, 6, type.getMetadata()), (Object[])new Object[]{"xxx", Character.valueOf('x'), baseItemBlock});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("cathedral", this.stairsEndstone.get(type.getMetadata()).getRegistryName().func_110623_a()), null, (ItemStack)new ItemStack(this.stairsEndstone.get(type.getMetadata()), 8), (Object[])new Object[]{"x  ", "xx ", "xxx", Character.valueOf('x'), baseItemBlock});
        }
    }

    @Override
    public void registerModels(ModelRegistryEvent event) {
        ((BlockMultiVariant)this.blockStone).registerItemModels();
        ((BlockMultiVariant)this.blockEndstone).registerItemModels();
        for (FeatureTypes.EnumEndStoneSlabType type : FeatureTypes.EnumEndStoneSlabType.values()) {
            ModelHelper.regModel(Item.func_150898_a((Block)this.slabEndstone), type.getMetadata(), new ResourceLocation("cathedral", this.slabEndstone.getRegistryName().func_110623_a() + "." + type.getUnlocalizedName()));
        }
        this.stairsEndstone.forEach(s -> ModelHelper.regModel(s));
    }

    @Override
    public void init() {
        for (FeatureTypes.EnumStoneType enumStoneType : FeatureTypes.EnumStoneType.values()) {
            this.addChiselVariation("stonebrick", this.blockStone, enumStoneType.getMetadata());
        }
        for (Enum enum_ : FeatureTypes.EnumEndStoneType.values()) {
            this.addChiselVariation("endstone", this.blockEndstone, ((FeatureTypes.EnumEndStoneType)enum_).getMetadata());
        }
        for (Enum enum_ : FeatureTypes.EnumEndStoneSlabType.values()) {
            this.addChiselVariation("endstoneslab", this.slabEndstone, ((FeatureTypes.EnumEndStoneSlabType)enum_).getMetadata());
        }
        this.stairsEndstone.forEach(s -> this.addChiselVariation("endstonestairs", (Block)s, 0));
    }

    private void addChiselVariation(String group, Block block, int meta) {
        FMLInterModComms.sendMessage((String)"chisel", (String)"variation:add", (String)(group + "|" + block.getRegistryName() + "|" + meta));
    }

    @Override
    public void postInit() {
    }
}

