/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.cathedral.models;

import com.ferreusveritas.cathedral.common.blocks.MimicProperty;
import com.ferreusveritas.cathedral.features.cathedral.BlockDeckPrism;
import com.ferreusveritas.cathedral.features.roofing.BlockShinglesSlab;
import com.ferreusveritas.cathedral.util.UnpackedModel;
import com.ferreusveritas.cathedral.util.UnpackedQuad;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BakedModelBlockDeckPrism
implements IBakedModel {
    protected IBakedModel prismModel;

    public BakedModelBlockDeckPrism(IBakedModel prismModel) {
        this.prismModel = prismModel;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (state != null && state.func_177230_c() instanceof MimicProperty.IMimic && state instanceof IExtendedBlockState) {
            UnpackedModel unpackedModel;
            Map<EnumFacing, List<BakedQuad>> quadMap;
            List<BakedQuad> q2;
            IExtendedBlockState extendedState = (IExtendedBlockState)state;
            IBlockState mimicState = (IBlockState)extendedState.getValue((IUnlistedProperty)MimicProperty.MIMIC);
            IBakedModel mimicModel = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(mimicState);
            DonutShape donutShape = this.getDonutShape(mimicState);
            if (MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.TRANSLUCENT) {
                EnumDyeColor color = (EnumDyeColor)extendedState.getValue(BlockDeckPrism.COLOR);
                UnpackedModel unpackedModel2 = new UnpackedModel(this.prismModel, state, 0L).color(color.func_193350_e() | 0xFF000000);
                if (side == null) {
                    unpackedModel2.apply(q -> q.face == EnumFacing.UP, q -> q.move(new Vec3d(0.0, -(1.0 - donutShape.aabb.field_72337_e), 0.0)));
                    unpackedModel2.apply(q -> q.face != EnumFacing.UP, q -> q.move(new Vec3d(0.0, donutShape.aabb.field_72338_b, 0.0)));
                    quads.addAll((Collection<BakedQuad>)unpackedModel2.pack().get(null));
                }
            }
            if (MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.SOLID && (q2 = (quadMap = this.makeDonut(unpackedModel = new UnpackedModel(mimicModel, mimicState, 0L), 3, donutShape)).get(side)) != null) {
                quads.addAll(q2);
            }
        }
        return quads;
    }

    protected DonutShape getDonutShape(IBlockState state) {
        DonutShape donutShape = DonutShape.FULL;
        Block block = state.func_177230_c();
        if (block instanceof BlockSlab) {
            BlockSlab slab = (BlockSlab)block;
            if (!slab.func_176552_j() && state.func_177227_a().contains(BlockSlab.field_176554_a)) {
                BlockSlab.EnumBlockHalf slabHalf = (BlockSlab.EnumBlockHalf)state.func_177229_b((IProperty)BlockSlab.field_176554_a);
                donutShape = slabHalf == BlockSlab.EnumBlockHalf.BOTTOM ? DonutShape.SLAB_BOTTOM : DonutShape.SLAB_TOP;
            }
        } else if (block instanceof BlockShinglesSlab) {
            BlockSlab.EnumBlockHalf slabHalf = (BlockSlab.EnumBlockHalf)state.func_177229_b((IProperty)BlockSlab.field_176554_a);
            donutShape = slabHalf == BlockSlab.EnumBlockHalf.BOTTOM ? DonutShape.SLAB_BOTTOM : DonutShape.SLAB_TOP;
        }
        return donutShape;
    }

    private Map<EnumFacing, List<BakedQuad>> makeDonut(UnpackedModel unpackedModel, int texelRadius, DonutShape shape) {
        AxisAlignedBB[] aabbs;
        Map<EnumFacing, List<BakedQuad>> quadMap = UnpackedModel.newBakedStorage();
        AxisAlignedBB envelope = shape.aabb;
        unpackedModel = unpackedModel.makeFullBlock();
        unpackedModel.makePartialBlock(envelope).packInto(q -> q.face.func_176740_k().func_176722_c(), quadMap);
        float radius = (float)texelRadius / 16.0f;
        float min = 0.5f - radius;
        float max = 0.5f + radius;
        for (AxisAlignedBB aabb : aabbs = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, (double)min), new AxisAlignedBB(0.0, 0.0, (double)max, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, (double)min, (double)min, 1.0, (double)max), new AxisAlignedBB((double)max, 0.0, (double)min, 1.0, 1.0, (double)max)}) {
            unpackedModel.makePartialBlock(aabb.func_191500_a(envelope)).packInto(q -> q.face.func_176740_k().func_176720_b(), quadMap);
        }
        AxisAlignedBB holeAABB = new AxisAlignedBB((double)min, 0.0, (double)min, (double)max, 1.0, (double)max).func_191500_a(envelope);
        UnpackedModel pbm = unpackedModel.makePartialBlock(holeAABB);
        for (UnpackedQuad quad : pbm.getQuads(q -> q.face.func_176740_k().func_176722_c())) {
            quad.move(new Vec3d(quad.face.func_176734_d().func_176730_m()).func_186678_a((double)(radius * 2.0f))).color(0.875f);
            quadMap.get(null).add(quad.pack());
        }
        return quadMap;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return true;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.prismModel.func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return null;
    }

    static enum DonutShape {
        FULL(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)),
        SLAB_TOP(new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0)),
        SLAB_BOTTOM(new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));

        public final AxisAlignedBB aabb;

        private DonutShape(AxisAlignedBB aabb) {
            this.aabb = aabb;
        }
    }
}

