/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.cathedral.models;

import com.ferreusveritas.cathedral.features.cathedral.EnumMaterial;
import com.ferreusveritas.cathedral.models.BakedModelBlockPillar;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;

public class ModelBlockPillar
implements IModel {
    private IModel modelShaft;
    private IModel modelBase;
    private IModel modelHead;
    private IModel modelJoin;
    private EnumMaterial material;

    public ModelBlockPillar(ResourceLocation modelLocation) {
        try {
            this.modelShaft = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(modelLocation.func_110624_b(), "block/cathedral/pillar_shaft"));
            this.modelBase = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(modelLocation.func_110624_b(), "block/cathedral/pillar_base"));
            this.modelHead = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(modelLocation.func_110624_b(), "block/cathedral/pillar_head"));
            this.modelJoin = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(modelLocation.func_110624_b(), "block/cathedral/pillar_join"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (modelLocation instanceof ModelResourceLocation) {
            ModelResourceLocation mrl = (ModelResourceLocation)modelLocation;
            this.material = EnumMaterial.byName(mrl.func_177518_c());
        }
    }

    public Collection<ResourceLocation> getTextures() {
        return this.getTextureMap().values();
    }

    private Map<String, ResourceLocation> generic(EnumMaterial material, ResourceLocation defaultTexture) {
        String name = material.func_176610_l();
        String path = "cathedral:blocks/cathedral/";
        String prefix = "pillar_";
        HashMap<String, ResourceLocation> stuff = new HashMap<String, ResourceLocation>();
        stuff.put("default", defaultTexture);
        stuff.put("shaftside", new ResourceLocation(path + prefix + name + "_shaft_side"));
        stuff.put("headside", new ResourceLocation(path + prefix + name + "_head_side"));
        stuff.put("headbottom", new ResourceLocation(path + prefix + name + "_head_bottom"));
        stuff.put("basetop", new ResourceLocation(path + prefix + name + "_base_top"));
        stuff.put("baseside", new ResourceLocation(path + prefix + name + "_base_side"));
        return stuff;
    }

    private Map<String, ResourceLocation> getTextureMap() {
        return this.generic(this.material, this.material.getFlatTexture());
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        Map<String, String> stuff = this.getTextureMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ResourceLocation)e.getValue()).toString()));
        ImmutableMap textures = ImmutableMap.copyOf(stuff);
        IBakedModel bakedShaft = this.modelShaft.retexture(textures).bake(state, format, bakedTextureGetter);
        IBakedModel bakedBase = this.modelBase.retexture(textures).bake(state, format, bakedTextureGetter);
        IBakedModel bakedHead = this.modelHead.retexture(textures).bake(state, format, bakedTextureGetter);
        IBakedModel[] bakedJoins = new IBakedModel[4];
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            int i = dir.func_176736_b();
            bakedJoins[i] = this.modelJoin.uvlock(true).retexture(textures).bake((IModelState)ModelRotation.func_177524_a((int)0, (int)(i * 90)), format, bakedTextureGetter);
        }
        TextureAtlasSprite particleSprite = bakedTextureGetter.apply(this.material.getFlatTexture());
        return new BakedModelBlockPillar(bakedShaft, bakedBase, bakedHead, bakedJoins, particleSprite);
    }
}

