/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.guidebook.shadow.commons.state.implementation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import gigaherz.guidebook.shadow.commons.state.IItemState;
import gigaherz.guidebook.shadow.commons.state.IItemStateManager;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.ArrayUtils;

public class ItemStateManager
implements IItemStateManager {
    private final Item item;
    private final ItemState[] stateTable;
    private final IProperty[] properties;
    private final Comparable[][] propertyValues;
    private IItemState defaultState;

    public <T extends Item> ItemStateManager(T item, IProperty ... properties) {
        this.item = item;
        this.properties = properties;
        this.propertyValues = new Comparable[properties.length][];
        Arrays.sort(properties);
        int combinations = 1;
        for (int i = 0; i < properties.length; ++i) {
            IProperty prop = properties[i];
            Collection allowed = prop.func_177700_c();
            Comparable[] values = allowed.toArray(new Comparable[allowed.size()]);
            this.propertyValues[i] = values;
            combinations *= values.length;
        }
        this.stateTable = new ItemState[combinations];
        ArrayDeque<Comparable> values = new ArrayDeque<Comparable>();
        int lastState = this.enumStates(properties, 0, 0, values);
        assert (lastState == combinations);
        this.defaultState = this.stateTable[0];
    }

    private int enumStates(IProperty[] properties, int p, int state, Deque<Comparable> values) {
        Comparable[] propValues;
        for (Comparable o : propValues = this.propertyValues[p]) {
            values.push(o);
            if (p + 1 >= properties.length) {
                this.stateTable[state] = new ItemState(state, values.toArray(new Comparable[values.size()]));
                ++state;
            } else {
                state = this.enumStates(properties, p + 1, state, values);
            }
            values.pop();
        }
        return state;
    }

    @Override
    @Nullable
    public IItemState get(int metadata) {
        if (metadata < 0 || metadata >= this.stateTable.length) {
            return null;
        }
        return this.stateTable[metadata];
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    @Override
    public ImmutableList<IProperty> getProperties() {
        return ImmutableList.copyOf((Object[])this.properties);
    }

    @Override
    public IItemState getDefaultState() {
        return this.defaultState;
    }

    @Override
    public void setDefaultState(IItemState defaultState) {
        this.defaultState = defaultState;
    }

    @Override
    public ImmutableList<IItemState> getStateTable() {
        return ImmutableList.copyOf((Object[])this.stateTable);
    }

    public class ItemState
    implements IItemState {
        private final int metadata;
        private Comparable[] values;

        ItemState(int metadata, Comparable[] values) {
            this.metadata = metadata;
            this.values = values;
        }

        @Override
        public int getMetadata() {
            return this.metadata;
        }

        @Override
        public ItemStack getStack() {
            return this.getStack(1);
        }

        @Override
        public ItemStack getStack(int count) {
            return new ItemStack(ItemStateManager.this.item, count, this.metadata);
        }

        @Override
        public <T extends Comparable<T>> IItemState withProperty(IProperty<T> property, T value) {
            int lastSize = 1;
            int meta = 0;
            for (int i = 0; i < ItemStateManager.this.properties.length; ++i) {
                Object[] values = ItemStateManager.this.propertyValues[i];
                int idx = ItemStateManager.this.properties[i] == property ? ArrayUtils.indexOf((Object[])values, value) : ArrayUtils.indexOf((Object[])values, (Object)this.values[i]);
                meta = meta * lastSize + idx;
                lastSize = values.length;
            }
            return ItemStateManager.this.stateTable[meta];
        }

        @Override
        public <T extends Comparable<T>> T getValue(IProperty<T> property) {
            int i = ArrayUtils.indexOf((Object[])ItemStateManager.this.properties, property);
            return (T)this.values[i];
        }

        @Override
        public ImmutableList<Comparable> getValues() {
            return ImmutableList.copyOf((Object[])this.values);
        }

        @Override
        public ImmutableMap<IProperty<?>, Comparable<?>> getProperties() {
            ImmutableMap.Builder b = new ImmutableMap.Builder();
            for (int i = 0; i < ItemStateManager.this.properties.length; ++i) {
                IProperty prop = ItemStateManager.this.properties[i];
                Comparable value = this.values[i];
                b.put((Object)prop, (Object)value);
            }
            return b.build();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < ItemStateManager.this.properties.length; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(ItemStateManager.this.properties[i].func_177701_a());
                sb.append("=");
                sb.append(ItemStateManager.this.properties[i].func_177702_a(this.values[i]));
            }
            return sb.toString();
        }
    }
}

