/*
 * Decompiled with CFR 0.152.
 */
package info.tritusk.modpack.crafttweaker.support.railcraft;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import info.tritusk.modpack.crafttweaker.support.railcraft.RailcraftTweaker;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import mods.railcraft.api.crafting.Crafters;
import mods.railcraft.api.crafting.ICokeOvenCrafter;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ModOnly(value="railcraft")
@ZenClass(value="mods.railcraft.CokeOven")
@ZenRegister
public final class CokeOvenSupport {
    @ZenMethod
    public static void addRecipe(final String name, final IItemStack output, final IIngredient input, final @Optional(valueLong=1800L) int time, final @Optional ILiquidStack outputFluid) {
        RailcraftTweaker.DELAYED_ACTIONS.add(new IAction(){

            public void apply() {
                ((ICokeOvenCrafter.ICokeOvenRecipeBuilder)((ICokeOvenCrafter.ICokeOvenRecipeBuilder)((ICokeOvenCrafter.ICokeOvenRecipeBuilder)Crafters.cokeOven().newRecipe((Object)CraftTweakerMC.getIngredient((IIngredient)input)).name(name)).output(CraftTweakerMC.getItemStack((IItemStack)output))).time(time)).fluid(CraftTweakerMC.getLiquidStack((ILiquidStack)outputFluid)).register();
            }

            public String describe() {
                return null;
            }
        });
    }

    @ZenMethod
    public static void removeRecipe(String name) {
        RailcraftTweaker.DELAYED_REMOVALS.add(new PreciseRemoval(name));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output, @Optional IIngredient input) {
        RailcraftTweaker.DELAYED_REMOVALS.add(new FuzzyRemoval(output, input));
    }

    private static final class FuzzyRemoval
    implements IAction {
        private final ItemStack output;
        private final Ingredient input;

        FuzzyRemoval(IItemStack output, IIngredient input) {
            this.output = CraftTweakerMC.getItemStack((IItemStack)output);
            this.input = CraftTweakerMC.getIngredient((IIngredient)input);
        }

        public void apply() {
            CraftTweakerAPI.logWarning((String)"Using CokeOven.removeRecipe(IItemStack, @Optional IIngredient) is strongly discouraged. Use the String one whenever possible.");
            List recipes = Crafters.cokeOven().getRecipes();
            Iterator itr = recipes.iterator();
            while (itr.hasNext()) {
                ICokeOvenCrafter.IRecipe recipe = (ICokeOvenCrafter.IRecipe)itr.next();
                if (!recipe.getOutput().func_77969_a(this.output) || this.input != null && this.input != Ingredient.field_193370_a && !recipe.getInput().equals(this.input)) continue;
                itr.remove();
            }
        }

        public String describe() {
            return null;
        }
    }

    private static final class PreciseRemoval
    implements IAction {
        private final String recipeName;

        PreciseRemoval(String recipeName) {
            this.recipeName = recipeName;
        }

        public void apply() {
            Crafters.cokeOven().getRecipes().removeIf(r -> this.recipeName.equals(r.getName().toString()));
        }

        public String describe() {
            return String.format(Locale.ENGLISH, "Remove Coke Oven recipe '%s'", this.recipeName);
        }
    }
}

