/*
 * Decompiled with CFR 0.152.
 */
package info.tritusk.modpack.crafttweaker.support.railcraft;

import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.liquid.ILiquidDefinition;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import info.tritusk.modpack.crafttweaker.support.railcraft.RailcraftTweaker;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import mods.railcraft.api.fuel.FluidFuelManager;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ModOnly(value="railcraft")
@ZenClass(value="mods.railcraft.FluidFuel")
@ZenRegister
public final class FluidFuelSupport {
    @ZenMethod
    public static void addFuel(final ILiquidStack liquid, final int heatValuePerBucket) {
        RailcraftTweaker.DELAYED_ACTIONS.add(new IAction(){

            public void apply() {
                FluidFuelManager.addFuel((FluidStack)CraftTweakerMC.getLiquidStack((ILiquidStack)liquid), (int)heatValuePerBucket);
            }

            public String describe() {
                return null;
            }
        });
    }

    @ZenMethod
    public static void addFuel(final ILiquidDefinition liquidType, final int heatValuePerBucket) {
        RailcraftTweaker.DELAYED_ACTIONS.add(new IAction(){

            public void apply() {
                FluidFuelManager.addFuel((Fluid)CraftTweakerMC.getFluid((ILiquidDefinition)liquidType), (int)heatValuePerBucket);
            }

            public String describe() {
                return null;
            }
        });
    }

    @ZenMethod
    public static void removeFuel(ILiquidStack liquid) {
        FluidFuelSupport.removeFuel(liquid.getDefinition());
    }

    @ZenMethod
    public static void removeFuel(ILiquidDefinition liquidType) {
        RailcraftTweaker.DELAYED_REMOVALS.add(new FuelRemoval(liquidType));
    }

    private static final class FuelRemoval
    implements IAction {
        static Map<FluidStack, Integer> fuelRegistryRef;
        private final Fluid fluidType;

        private FuelRemoval(ILiquidDefinition fluidType) {
            this.fluidType = CraftTweakerMC.getFluid((ILiquidDefinition)fluidType);
        }

        public void apply() {
            Iterator<Map.Entry<FluidStack, Integer>> itr = fuelRegistryRef.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<FluidStack, Integer> entry = itr.next();
                if (entry.getKey().getFluid() != this.fluidType) continue;
                itr.remove();
                return;
            }
        }

        public String describe() {
            return String.format(Locale.ENGLISH, "Remove '%s' as valid Railcraft boiler fuel", this.fluidType.getName());
        }

        static {
            try {
                fuelRegistryRef = (Map)FluidFuelManager.class.getDeclaredField("boilerFuel").get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                fuelRegistryRef = Collections.emptyMap();
            }
        }
    }
}

