/*
 * Decompiled with CFR 0.152.
 */
package info.tritusk.modpack.crafttweaker.support.railcraft;

import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import info.tritusk.modpack.crafttweaker.support.railcraft.RailcraftTweaker;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Objects;
import mods.railcraft.api.crafting.Crafters;
import mods.railcraft.api.crafting.IRollingMachineCrafter;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ModOnly(value="railcraft")
@ZenClass(value="mods.railcraft.RollingMachine")
@ZenRegister
public final class RollingMachineSupport {
    @ZenMethod
    public static void addShaped(final String name, final IItemStack output, final IIngredient[][] inputs, final @Optional(valueLong=100L) int time) {
        RailcraftTweaker.DELAYED_ACTIONS.add(new IAction(){

            public void apply() {
                IIngredient[][] in = inputs;
                int width = 0;
                for (IIngredient[] row : in) {
                    if (row.length <= width) continue;
                    width = row.length;
                }
                int height = in.length;
                ((IRollingMachineCrafter.IRollingMachineRecipeBuilder)((IRollingMachineCrafter.IRollingMachineRecipeBuilder)Crafters.rollingMachine().newRecipe(CraftTweakerMC.getItemStack((IItemStack)output)).name("crafttweaker", name)).time(time)).recipe((IRecipe)new ShapedRecipes("railcraft-tweaker", width, height, Arrays.stream(in).flatMap(Arrays::stream).map(CraftTweakerMC::getIngredient).collect(NonNullList::func_191196_a, AbstractList::add, AbstractCollection::addAll), CraftTweakerMC.getItemStack((IItemStack)output)));
            }

            public String describe() {
                return null;
            }
        });
    }

    @ZenMethod
    public static void addShapeless(final String name, final IItemStack output, final IIngredient[] inputs, final @Optional(valueLong=100L) int time) {
        RailcraftTweaker.DELAYED_ACTIONS.add(new IAction(){

            public void apply() {
                ((IRollingMachineCrafter.IRollingMachineRecipeBuilder)((IRollingMachineCrafter.IRollingMachineRecipeBuilder)Crafters.rollingMachine().newRecipe(CraftTweakerMC.getItemStack((IItemStack)output)).name("crafttweaker", name)).time(time)).recipe((IRecipe)new ShapelessRecipes("railcraft-tweaker", CraftTweakerMC.getItemStack((IItemStack)output), Arrays.stream(inputs).map(CraftTweakerMC::getIngredient).collect(NonNullList::func_191196_a, AbstractList::add, AbstractCollection::addAll)));
            }

            public String describe() {
                return null;
            }
        });
    }

    @ZenMethod
    public static void remove(String name) {
        RailcraftTweaker.DELAYED_REMOVALS.add(new PreciseRemoval(name));
    }

    @ZenMethod
    public static void remove(IItemStack output) {
        RollingMachineSupport.removeByOutput(output);
    }

    @ZenMethod
    public static void removeByOutput(IItemStack output) {
        RailcraftTweaker.DELAYED_REMOVALS.add(new FuzzyRemoval(CraftTweakerMC.getItemStack((IItemStack)output)));
    }

    private static final class FuzzyRemoval
    implements IAction {
        private final ItemStack output;

        FuzzyRemoval(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            Crafters.rollingMachine().getRecipes().removeIf(recipe -> recipe.func_77571_b().func_77969_a(this.output));
        }

        public String describe() {
            return null;
        }
    }

    private static final class PreciseRemoval
    implements IAction {
        private final String recipeName;

        PreciseRemoval(String name) {
            this.recipeName = name;
        }

        public void apply() {
            Crafters.rollingMachine().getRecipes().removeIf(r -> Objects.toString(r.getRegistryName()).equals(this.recipeName));
        }

        public String describe() {
            return null;
        }
    }
}

