/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod;

import appeng.api.AEApi;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.util.IReadOnlyCollection;
import appeng.me.helpers.IGridProxyable;
import appeng.tile.crafting.TileCraftingMonitorTile;
import appeng.tile.storage.TileChest;
import appeng.tile.storage.TileDrive;
import com.zuxelus.energycontrol.EnergyControl;
import com.zuxelus.energycontrol.crossmod.CrossModBase;
import com.zuxelus.energycontrol.items.cards.ItemCardAppEng;
import com.zuxelus.energycontrol.items.cards.ItemCardAppEngInv;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.items.kits.ItemKitAppEng;
import com.zuxelus.energycontrol.items.kits.ItemKitMain;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;

public class CrossAppEng
extends CrossModBase {
    @Override
    public NBTTagCompound getEnergyData(TileEntity te) {
        if (te instanceof IAEPowerStorage) {
            NBTTagCompound tag = new NBTTagCompound();
            IAEPowerStorage storage = (IAEPowerStorage)te;
            tag.func_74778_a("euType", "AE");
            tag.func_74780_a("energy", storage.getAECurrentPower());
            tag.func_74780_a("capacity", storage.getAEMaxPower());
            return tag;
        }
        return null;
    }

    @Override
    public NBTTagCompound getCardData(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        int[] values = new int[]{0, 0, 0, 0, 0};
        IReadOnlyCollection list = null;
        NBTTagCompound tag = new NBTTagCompound();
        if (te instanceof TileCraftingMonitorTile) {
            TileCraftingMonitorTile tile = (TileCraftingMonitorTile)te;
            tag.func_74768_a("type", 0);
            if (tile.getJobProgress() != null) {
                tag.func_74768_a("type", 2);
                tag.func_74778_a("name", EnergyControl.proxy.getItemName(tile.getJobProgress().createItemStack()));
                tag.func_74768_a("size", (int)tile.getJobProgress().getStackSize());
            }
            return tag;
        }
        if (te instanceof IGridProxyable) {
            list = ((IGridProxyable)te).getProxy().getNode().getGrid().getNodes();
        }
        if (list == null) {
            return null;
        }
        int cells = 0;
        for (IGridNode node : list) {
            IGridHost host = node.getMachine();
            if (host instanceof TileChest) {
                ItemStack stack = ((TileChest)host).getCell();
                cells += this.calcValues(stack, values);
                continue;
            }
            if (!(host instanceof TileDrive)) continue;
            for (int i = 0; i < ((TileDrive)host).getInternalInventory().getSlots(); ++i) {
                ItemStack stack = ((TileDrive)host).getInternalInventory().getStackInSlot(i);
                cells += this.calcValues(stack, values);
            }
        }
        tag.func_74768_a("type", 1);
        tag.func_74768_a("nodes", list.size());
        tag.func_74768_a("cells", cells);
        tag.func_74768_a("bytesTotal", values[0]);
        tag.func_74768_a("bytesUsed", values[1]);
        tag.func_74768_a("typesTotal", values[2]);
        tag.func_74768_a("typesUsed", values[3]);
        tag.func_74768_a("items", values[4]);
        return tag;
    }

    private int calcValues(ItemStack stack, int[] values) {
        if (stack == null) {
            return 0;
        }
        int cells = 0;
        for (IStorageChannel channel : AEApi.instance().storage().storageChannels()) {
            ICellInventory inv;
            ICellInventoryHandler handler = AEApi.instance().registries().cell().getCellInventory(stack, null, channel);
            if (handler == null || (inv = handler.getCellInv()) == null) continue;
            values[0] = (int)((long)values[0] + inv.getTotalBytes());
            values[1] = (int)((long)values[1] + inv.getUsedBytes());
            values[2] = (int)((long)values[2] + inv.getTotalItemTypes());
            values[3] = (int)((long)values[3] + inv.getStoredItemTypes());
            values[4] = (int)((long)values[4] + inv.getStoredItemCount());
            ++cells;
        }
        return cells;
    }

    @Override
    public void registerItems(RegistryEvent.Register<Item> event) {
        ItemKitMain.register(ItemKitAppEng::new);
        ItemCardMain.register(ItemCardAppEng::new);
        ItemCardMain.register(ItemCardAppEngInv::new);
    }
}

