/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod;

import com.brandon3055.draconicevolution.api.IExtendedRFStorage;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorComponent;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.blocks.tileentity.IMultiBlockPart;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCoreStabilizer;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyInfuser;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyStorageCore;
import com.brandon3055.draconicevolution.blocks.tileentity.TileGenerator;
import com.brandon3055.draconicevolution.blocks.tileentity.TileInvisECoreBlock;
import com.brandon3055.draconicevolution.blocks.tileentity.flowgate.TileFluidGate;
import com.brandon3055.draconicevolution.blocks.tileentity.flowgate.TileFluxGate;
import com.zuxelus.energycontrol.crossmod.CrossModBase;
import com.zuxelus.energycontrol.hooks.DraconicEvolutionHooks;
import com.zuxelus.energycontrol.items.cards.ItemCardDraconicEvolution;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.items.kits.ItemKitDraconicEvolution;
import com.zuxelus.energycontrol.items.kits.ItemKitMain;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;

public class CrossDraconicEvolution
extends CrossModBase {
    @Override
    public NBTTagCompound getEnergyData(TileEntity te) {
        IMultiBlockPart core;
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("euType", "RF");
        if (te instanceof IExtendedRFStorage) {
            tag.func_74780_a("energy", (double)((IExtendedRFStorage)te).getExtendedStorage());
            tag.func_74780_a("capacity", (double)((IExtendedRFStorage)te).getExtendedCapacity());
            return tag;
        }
        if (te instanceof TileInvisECoreBlock && (core = ((TileInvisECoreBlock)te).getController()) instanceof TileEnergyStorageCore) {
            tag.func_74780_a("energy", (double)((IExtendedRFStorage)core).getExtendedStorage());
            tag.func_74780_a("capacity", (double)((IExtendedRFStorage)core).getExtendedCapacity());
            return tag;
        }
        if (te instanceof TileEnergyInfuser) {
            tag.func_74780_a("energy", (double)((TileEnergyInfuser)te).energyStorage.getEnergyStored());
            tag.func_74780_a("capacity", (double)((TileEnergyInfuser)te).energyStorage.getMaxEnergyStored());
            return tag;
        }
        if (te instanceof TileCrystalBase) {
            tag.func_74780_a("energy", (double)((TileCrystalBase)te).getEnergyStored());
            tag.func_74780_a("capacity", (double)((TileCrystalBase)te).getMaxEnergyStored());
            return tag;
        }
        return null;
    }

    @Override
    public NBTTagCompound getCardData(World world, BlockPos pos) {
        IMultiBlockPart core;
        TileEntity te = world.func_175625_s(pos);
        NBTTagCompound tag = new NBTTagCompound();
        if (te instanceof TileInvisECoreBlock && (core = ((TileInvisECoreBlock)te).getController()) instanceof TileEnergyStorageCore) {
            return this.getStorageData((TileEnergyStorageCore)core);
        }
        if (te instanceof TileEnergyCoreStabilizer) {
            return this.getStorageData(((TileEnergyCoreStabilizer)te).findCore());
        }
        if (te instanceof TileEnergyStorageCore) {
            return this.getStorageData((TileEnergyStorageCore)te);
        }
        if (te instanceof TileGenerator) {
            tag.func_74757_a("active", ((TileGenerator)te).active.value);
            tag.func_74780_a("energy", (double)((TileGenerator)te).getEnergyStored(null));
            tag.func_74780_a("capacity", (double)((TileGenerator)te).getMaxEnergyStored(null));
            tag.func_74780_a("output", ((TileGenerator)te).active.value ? 84.0 : 0.0);
            return tag;
        }
        if (te instanceof TileCrystalBase) {
            tag.func_74780_a("energy", (double)((TileCrystalBase)te).getEnergyStored());
            tag.func_74780_a("capacity", (double)((TileCrystalBase)te).getMaxEnergyStored());
            tag.func_74768_a("connections", ((TileCrystalBase)te).getLinks().size());
            return tag;
        }
        if (te instanceof TileFluxGate) {
            tag.func_74768_a("flowLow", ((TileFluxGate)te).minFlow.value);
            tag.func_74768_a("flowHigh", ((TileFluxGate)te).maxFlow.value);
            return tag;
        }
        if (te instanceof TileFluidGate) {
            tag.func_74768_a("flowLowMB", ((TileFluidGate)te).minFlow.value);
            tag.func_74768_a("flowHighMB", ((TileFluidGate)te).maxFlow.value);
            return tag;
        }
        if (te instanceof TileReactorComponent) {
            return this.getReactorData(((TileReactorComponent)te).tryGetCore());
        }
        if (te instanceof TileReactorCore) {
            return this.getReactorData((TileReactorCore)te);
        }
        return null;
    }

    private NBTTagCompound getStorageData(TileEnergyStorageCore core) {
        if (core == null) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74780_a("energy", (double)core.getExtendedStorage());
        tag.func_74780_a("capacity", (double)core.getExtendedCapacity());
        ArrayList values = this.getHookValues((TileEntity)core);
        if (values != null) {
            tag.func_74772_a("diff", ((Long)values.get(0) - (Long)values.get(20)) / 20L);
        }
        tag.func_74768_a("tier", (int)core.tier.value);
        return tag;
    }

    private NBTTagCompound getReactorData(TileReactorCore reactor) {
        if (reactor == null) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("status", ((TileReactorCore.ReactorState)reactor.reactorState.value).name());
        tag.func_74780_a("temp", reactor.temperature.value);
        tag.func_74780_a("output", reactor.generationRate.value);
        tag.func_74780_a("consumption", reactor.fieldInputRate.value);
        tag.func_74780_a("diam", reactor.getCoreDiameter());
        tag.func_74780_a("saturation", (double)reactor.saturation.value * 100.0 / (double)reactor.maxSaturation.value);
        tag.func_74780_a("fuel", reactor.convertedFuel.value);
        tag.func_74780_a("shield", reactor.shieldCharge.value * 100.0 / reactor.maxShieldCharge.value);
        tag.func_74780_a("fuelMax", reactor.reactableFuel.value);
        tag.func_74780_a("fuelRate", reactor.fuelUseRate.value);
        return tag;
    }

    @Override
    public ArrayList getHookValues(TileEntity te) {
        ArrayList values = DraconicEvolutionHooks.map.get(te);
        if (values == null) {
            DraconicEvolutionHooks.map.put(te, null);
        }
        return values;
    }

    @Override
    public void registerItems(RegistryEvent.Register<Item> event) {
        ItemKitMain.register(ItemKitDraconicEvolution::new);
        ItemCardMain.register(ItemCardDraconicEvolution::new);
    }
}

