/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.gui;

import com.zuxelus.energycontrol.containers.ContainerRangeTrigger;
import com.zuxelus.energycontrol.gui.controls.CompactButton;
import com.zuxelus.energycontrol.gui.controls.GuiRangeTriggerInvertRedstone;
import com.zuxelus.energycontrol.network.NetworkHelper;
import com.zuxelus.energycontrol.tileentities.TileEntityRangeTrigger;
import com.zuxelus.zlib.gui.GuiContainerBase;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiRangeTrigger
extends GuiContainerBase {
    private static final ResourceLocation TEXTURE = new ResourceLocation("energycontrol:textures/gui/gui_range_trigger.png");
    private ContainerRangeTrigger container;
    private ItemStack prevCard;

    public GuiRangeTrigger(ContainerRangeTrigger container) {
        super(container, "tile.range_trigger.name", TEXTURE);
        this.container = container;
        this.field_147000_g = 190;
    }

    private void initControls() {
        int i;
        ItemStack card = this.container.func_75139_a(0).func_75211_c();
        if (!card.func_190926_b() && card.equals(this.prevCard)) {
            return;
        }
        this.field_146292_n.clear();
        this.prevCard = card;
        for (i = 0; i < 10; ++i) {
            this.func_189646_b(new CompactButton(i * 10, this.field_147003_i + 30 + i * 12 + (i + 2) / 3 * 6, this.field_147009_r + 20, 12, 12, "-"));
            this.func_189646_b(new CompactButton(i * 10 + 1, this.field_147003_i + 30 + i * 12 + (i + 2) / 3 * 6, this.field_147009_r + 42, 12, 12, "+"));
        }
        for (i = 0; i < 10; ++i) {
            this.func_189646_b(new CompactButton(100 + i * 10, this.field_147003_i + 30 + i * 12 + (i + 2) / 3 * 6, this.field_147009_r + 57, 12, 12, "-"));
            this.func_189646_b(new CompactButton(100 + i * 10 + 1, this.field_147003_i + 30 + i * 12 + (i + 2) / 3 * 6, this.field_147009_r + 79, 12, 12, "+"));
        }
        this.func_189646_b(new GuiRangeTriggerInvertRedstone(0, this.field_147003_i + 8, this.field_147009_r + 62, (TileEntityRangeTrigger)this.container.te));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.initControls();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    private void renderValue(double value, int x, int y) {
        x += 114;
        for (int i = 0; i < 10; ++i) {
            byte digit = (byte)(value % 10.0);
            String str = Byte.toString(digit);
            this.field_146289_q.func_78276_b(str, x - 12 * i - this.field_146289_q.func_78263_a(str.charAt(0)) / 2 + (9 - i + 2) / 3 * 6, y, 0x404040);
            value /= 10.0;
        }
    }

    protected void func_146284_a(GuiButton button) {
        long initValue;
        if (button instanceof GuiRangeTriggerInvertRedstone) {
            return;
        }
        int id = button.field_146127_k;
        boolean isPlus = id % 2 == 1;
        int power = 9 - (id /= 10) % 10;
        boolean isEnd = (id /= 10) % 2 == 1;
        long newValue = initValue = isEnd ? ((TileEntityRangeTrigger)this.container.te).levelEnd : ((TileEntityRangeTrigger)this.container.te).levelStart;
        long delta = (long)Math.pow(10.0, power);
        long digit = initValue / delta % 10L;
        if (digit == 0L && !isPlus || digit == 9L && isPlus) {
            return;
        }
        if (isPlus && digit < 9L) {
            newValue += delta;
        } else if (!isPlus && digit > 0L) {
            newValue -= delta;
        }
        if (newValue != initValue && (isEnd && newValue >= ((TileEntityRangeTrigger)this.container.te).levelStart || !isEnd && ((TileEntityRangeTrigger)this.container.te).levelEnd >= newValue)) {
            TileEntityRangeTrigger trigger = (TileEntityRangeTrigger)this.container.te;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74772_a("value", newValue);
            if (isEnd) {
                tag.func_74768_a("type", 3);
                NetworkHelper.updateSeverTileEntity(trigger.func_174877_v(), tag);
                trigger.setLevelEnd(newValue);
            } else {
                tag.func_74768_a("type", 1);
                NetworkHelper.updateSeverTileEntity(trigger.func_174877_v(), tag);
                trigger.setLevelStart(newValue);
            }
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawCenteredText(this.name, this.field_146999_f, 6);
        this.drawLeftAlignedText(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2);
        this.renderValue(((TileEntityRangeTrigger)this.container.te).levelStart, 30, 33);
        this.renderValue(((TileEntityRangeTrigger)this.container.te).levelEnd, 30, 70);
    }
}

