/*
 * Decompiled with CFR 0.152.
 */
package fr.wind_blade.isorropia.common;

import fr.wind_blade.isorropia.Isorropia;
import fr.wind_blade.isorropia.common.IsorropiaAPI;
import fr.wind_blade.isorropia.common.IsorropiaCreativeTabs;
import fr.wind_blade.isorropia.common.blocks.BlockCurativeVat;
import fr.wind_blade.isorropia.common.blocks.BlocksIS;
import fr.wind_blade.isorropia.common.capabilities.LivingBaseCapability;
import fr.wind_blade.isorropia.common.capabilities.LivingCapability;
import fr.wind_blade.isorropia.common.casters.foci.FocusEffectContainment;
import fr.wind_blade.isorropia.common.config.Config;
import fr.wind_blade.isorropia.common.curative.CurativeEffects;
import fr.wind_blade.isorropia.common.entities.EntityChocow;
import fr.wind_blade.isorropia.common.entities.EntityChromaticSheep;
import fr.wind_blade.isorropia.common.entities.EntityDopeSquid;
import fr.wind_blade.isorropia.common.entities.EntityGoldenChicken;
import fr.wind_blade.isorropia.common.entities.EntityGravekeeper;
import fr.wind_blade.isorropia.common.entities.EntityGuardianPanther;
import fr.wind_blade.isorropia.common.entities.EntityHangingLabel;
import fr.wind_blade.isorropia.common.entities.EntityHellHound;
import fr.wind_blade.isorropia.common.entities.EntityJellyRabbit;
import fr.wind_blade.isorropia.common.entities.EntityOrePig;
import fr.wind_blade.isorropia.common.entities.EntityScholarChicken;
import fr.wind_blade.isorropia.common.entities.EntitySheeder;
import fr.wind_blade.isorropia.common.entities.EntityTaintPig;
import fr.wind_blade.isorropia.common.entities.projectile.EntityEmber;
import fr.wind_blade.isorropia.common.entities.projectile.EntityIncubatedEgg;
import fr.wind_blade.isorropia.common.events.EntityEventHandler;
import fr.wind_blade.isorropia.common.events.RegistryEventHandler;
import fr.wind_blade.isorropia.common.items.ItemsIS;
import fr.wind_blade.isorropia.common.items.JellyAspectEffects;
import fr.wind_blade.isorropia.common.lenses.AirLens;
import fr.wind_blade.isorropia.common.lenses.EnvyLens;
import fr.wind_blade.isorropia.common.lenses.FireLens;
import fr.wind_blade.isorropia.common.lenses.OrdoLens;
import fr.wind_blade.isorropia.common.network.CapabilityMessage;
import fr.wind_blade.isorropia.common.network.ISPacketFXInfusionSource;
import fr.wind_blade.isorropia.common.network.LensChangeMessage;
import fr.wind_blade.isorropia.common.network.LensRemoveMessage;
import fr.wind_blade.isorropia.common.network.LensRemoveMessageSP;
import fr.wind_blade.isorropia.common.network.MirrorMessage;
import fr.wind_blade.isorropia.common.network.ParticuleDestroyMessage;
import fr.wind_blade.isorropia.common.network.TrackingCapabilityMessage;
import fr.wind_blade.isorropia.common.research.ResearchsIS;
import fr.wind_blade.isorropia.common.tiles.TileJarSoul;
import fr.wind_blade.isorropia.common.tiles.TileModifiedMatrix;
import fr.wind_blade.isorropia.common.tiles.TileVat;
import fr.wind_blade.isorropia.common.tiles.TileVatBottom;
import fr.wind_blade.isorropia.common.tiles.TileVatConnector;
import java.util.concurrent.Callable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.casters.FocusEngine;
import thaumcraft.api.crafting.IDustTrigger;
import thaumcraft.api.crafting.Part;
import thaumcraft.common.lib.crafting.DustTriggerMultiblock;

public class Common {
    @CapabilityInject(value=LivingBaseCapability.class)
    public static final Capability<LivingBaseCapability> LIVING_BASE_CAPABILITY = null;
    @CapabilityInject(value=LivingCapability.class)
    public static final Capability<LivingCapability> LIVING_CAPABILITY = null;
    public static final SimpleNetworkWrapper INSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel("isorropia");
    public static final CreativeTabs isorropiaCreativeTabs = new IsorropiaCreativeTabs();

    public void preInit(FMLPreInitializationEvent event) {
        CapabilityManager.INSTANCE.register(LivingBaseCapability.class, (Capability.IStorage)new LivingBaseCapability.Storage(), (Callable)new LivingBaseCapability.Factory());
        CapabilityManager.INSTANCE.register(LivingCapability.class, (Capability.IStorage)new LivingCapability.Storage(), (Callable)new LivingCapability.Factory());
        Common.initTileEntity();
        Common.initHandlers();
        Common.initNetwork();
        Common.initEntities();
        Config.init(event);
    }

    public void init(FMLInitializationEvent event) {
        Config.initOreDictionary();
        ResearchsIS.init();
        GameRegistry.addSmelting((ItemStack)new ItemStack(ItemsIS.itemGoldEgg), (ItemStack)new ItemStack(Items.field_151074_bl), (float)0.15f);
    }

    public void postInit(FMLPostInitializationEvent event) {
        Common.initMultiBlocks();
        ResearchsIS.initAspects(event);
    }

    private static void initTileEntity() {
        GameRegistry.registerTileEntity(TileVat.class, (ResourceLocation)new ResourceLocation("isorropia", "curative_vat"));
        GameRegistry.registerTileEntity(TileVatBottom.class, (ResourceLocation)new ResourceLocation("isorropia", "curative_bottom"));
        GameRegistry.registerTileEntity(TileVatConnector.class, (ResourceLocation)new ResourceLocation("isorropia", "curative_connector"));
        GameRegistry.registerTileEntity(TileJarSoul.class, (ResourceLocation)new ResourceLocation("isorropia", "soul_jar"));
        GameRegistry.registerTileEntity(TileModifiedMatrix.class, (ResourceLocation)new ResourceLocation("isorropia", "modified_matrix"));
    }

    private static void initEntities() {
        Common.registerEntity("incubated_egg", EntityIncubatedEgg.class, 64, 1, true);
        Common.registerEntity("taint_pig", EntityTaintPig.class, 64, 3, true);
        Common.registerEntity("gravekeeper", EntityGravekeeper.class, 64, 3, true);
        Common.registerEntity("sheeder", EntitySheeder.class, 64, 3, true);
        Common.registerEntity("chromatic_sheep", EntityChromaticSheep.class, 64, 3, true);
        Common.registerEntity("scholar_chicken", EntityScholarChicken.class, 64, 3, true);
        Common.registerEntity("ore_pig", EntityOrePig.class, 64, 3, true);
        Common.registerEntity("jelly_rabbit", EntityJellyRabbit.class, 64, 3, true);
        Common.registerEntity("hanging_label", EntityHangingLabel.class, 160, Integer.MAX_VALUE, false);
        Common.registerEntity("chocolate_cow", EntityChocow.class, 64, 3, true);
        Common.registerEntity("golden_chicken", EntityGoldenChicken.class, 64, 3, true);
        Common.registerEntity("guardian_panther", EntityGuardianPanther.class, 64, 3, true);
        Common.registerEntity("nether_hound", EntityHellHound.class, 64, 3, true);
        Common.registerEntity("ember", EntityEmber.class, 64, 1, true);
        if (Loader.isModLoaded((String)"thaumicbases")) {
            Common.registerEntity("dope_squid", EntityDopeSquid.class, 64, 3, true);
        }
    }

    public static void initProviders() {
        FocusEngine.registerElement(FocusEffectContainment.class, (ResourceLocation)new ResourceLocation("isorropia", "textures/misc/containment.png"), (int)-13411841);
        IsorropiaAPI.registerLens(new AirLens(ItemsIS.itemAirLens), new ResourceLocation("isorropia", "air_lens"));
        IsorropiaAPI.registerLens(new FireLens(ItemsIS.itemFireLens), new ResourceLocation("isorropia", "fire_lens"));
        IsorropiaAPI.registerLens(new OrdoLens(ItemsIS.itemOrdoLens), new ResourceLocation("isorropia", "ordo_lens"));
        IsorropiaAPI.registerLens(new EnvyLens(ItemsIS.itemEnvyLens), new ResourceLocation("isorropia", "envy_lens"));
        IsorropiaAPI.registerCurativeEffect(new CurativeEffects.IGNIS_CURE());
        IsorropiaAPI.registerCurativeEffect(new CurativeEffects.LIFE_HEAL());
        IsorropiaAPI.registerCurativeEffect(new CurativeEffects.HUNGER_FOOD());
        IsorropiaAPI.registerCurativeEffect(new CurativeEffects.DEATH_HEAL());
        IsorropiaAPI.registerCurativeEffect(new CurativeEffects.UNDEAD_HEAL());
        IsorropiaAPI.bindJellyAspectEffect(null, new JellyAspectEffects.DEFAULT_EFFECT());
        IsorropiaAPI.bindJellyAspectEffect(Aspect.MOTION, new JellyAspectEffects.MOTION_EFFECT());
        IsorropiaAPI.bindJellyAspectEffect(Aspect.LIFE, new JellyAspectEffects.LIFE_EFFECT());
        IsorropiaAPI.bindJellyAspectEffect(Aspect.EXCHANGE, new JellyAspectEffects.EXCHANGE_EFFECT());
        IsorropiaAPI.bindJellyAspectEffect(Aspect.PROTECT, new JellyAspectEffects.PROTECT_EFFECT());
    }

    private static void initHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)new EntityEventHandler());
    }

    private static void initNetwork() {
        INSTANCE.registerMessage(MirrorMessage.MirrorMessageHandler.class, MirrorMessage.class, 0, Side.SERVER);
        INSTANCE.registerMessage(LensChangeMessage.LensChangeMessageHandler.class, LensChangeMessage.class, 1, Side.SERVER);
        INSTANCE.registerMessage(CapabilityMessage.ClientLivingBaseCapabilityHandler.class, CapabilityMessage.class, 2, Side.CLIENT);
        INSTANCE.registerMessage(ISPacketFXInfusionSource.class, ISPacketFXInfusionSource.class, 4, Side.CLIENT);
        INSTANCE.registerMessage(TrackingCapabilityMessage.ClientLivingBaseCapabilityHandler.class, TrackingCapabilityMessage.class, 5, Side.CLIENT);
        INSTANCE.registerMessage(ParticuleDestroyMessage.Handler.class, ParticuleDestroyMessage.class, 6, Side.CLIENT);
        INSTANCE.registerMessage(LensRemoveMessage.Handler.class, LensRemoveMessage.class, 7, Side.CLIENT);
        INSTANCE.registerMessage(LensRemoveMessageSP.Handler.class, LensRemoveMessageSP.class, 8, Side.SERVER);
    }

    private static void initMultiBlocks() {
        Part pl = new Part((Object)BlocksTC.plankGreatwood, (Object)BlocksIS.blockCurativeVat);
        Part co = new Part((Object)BlocksTC.plankGreatwood, (Object)new ItemStack((Block)BlocksIS.blockCurativeVat, 1, BlockCurativeVat.Type.CONNECTOR.getMetadata()));
        Part top = new Part((Object)BlocksTC.metalAlchemical, (Object)new ItemStack((Block)BlocksIS.blockCurativeVat, 1, BlockCurativeVat.Type.TOP.getMetadata()));
        Part bottom = new Part((Object)BlocksTC.metalAlchemical, (Object)new ItemStack((Block)BlocksIS.blockCurativeVat, 1, BlockCurativeVat.Type.BOTTOM.getMetadata()));
        Part gl = new Part((Object)Blocks.field_150359_w, (Object)BlocksIS.blockCurativeVat);
        Part in = new Part((Object)Material.field_151586_h, (Object)BlocksIS.blockVatInterior);
        Part[][][] curative_vat = new Part[][][]{{{pl, pl, pl}, {pl, top, pl}, {pl, pl, pl}}, {{gl, gl, gl}, {gl, in, gl}, {gl, gl, gl}}, {{gl, gl, gl}, {gl, in, gl}, {gl, gl, gl}}, {{pl, co, pl}, {co, bottom, co}, {pl, co, pl}}};
        IDustTrigger.registerDustTrigger((IDustTrigger)new DustTriggerMultiblock("CURATIVEVAT", (Part[][][])curative_vat));
        curative_vat = (Part[][][])curative_vat.clone();
        Part[][][] crafting_recipe = new Part[][][]{{{pl, pl, pl}, {pl, top, pl}, {pl, pl, pl}}, {{gl, gl, gl}, {gl, null, gl}, {gl, gl, gl}}, {{gl, gl, gl}, {gl, null, gl}, {gl, gl, gl}}, {{pl, co, pl}, {co, bottom, co}, {pl, co, pl}}};
        ThaumcraftApi.addFakeCraftingRecipe((ResourceLocation)new ResourceLocation("isorropia", "curative_vat"), (Object)new ThaumcraftApi.BluePrint("CURATIVEVAT", (Part[][][])crafting_recipe, new ItemStack[]{new ItemStack(BlocksTC.plankGreatwood, 16), new ItemStack(Blocks.field_150359_w, 16), new ItemStack(BlocksTC.metalAlchemical, 2, 0), new ItemStack(Items.field_151131_as, 2)}));
    }

    public static void initOreDictionary() {
        OreDictionary.registerOre((String)"slimeball", (ItemStack)new ItemStack((Item)ItemsIS.itemJelly));
        OreDictionary.registerOre((String)"dyeBlack", (ItemStack)new ItemStack(ItemsIS.itemInkEgg));
    }

    private static void registerEntity(String name, Class<? extends Entity> entityClass, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        ResourceLocation loc = new ResourceLocation("isorropia", name);
        EntityRegistry.registerModEntity((ResourceLocation)loc, entityClass, (String)name, (int)RegistryEventHandler.entities_id++, (Object)Isorropia.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
        if (EntityLiving.class.isAssignableFrom(entityClass)) {
            EntityRegistry.registerEgg((ResourceLocation)loc, (int)0, (int)1);
        }
        RegistryEventHandler.ENTITIES.put(name, entityClass);
    }

    public static LivingBaseCapability getCap(EntityLivingBase base) {
        if (base instanceof EntityLiving) {
            return (LivingBaseCapability)base.getCapability(LIVING_CAPABILITY, null);
        }
        return (LivingBaseCapability)base.getCapability(LIVING_BASE_CAPABILITY, null);
    }
}

