/*
 * Decompiled with CFR 0.152.
 */
package fr.wind_blade.isorropia.common.blocks;

import fr.wind_blade.isorropia.common.blocks.BlockLiquidVat;
import fr.wind_blade.isorropia.common.blocks.IBlockRegistry;
import fr.wind_blade.isorropia.common.tiles.TileVat;
import fr.wind_blade.isorropia.common.tiles.TileVatBottom;
import fr.wind_blade.isorropia.common.tiles.TileVatConnector;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCurativeVat
extends Block
implements ITileEntityProvider,
IBlockRegistry {
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"variant", Type.class);

    public BlockCurativeVat() {
        super(Material.field_151575_d);
        this.field_149784_t = 8;
        this.func_149711_c(2.0f);
    }

    public static TileVat getMaster(World world, BlockPos pos) {
        return BlockCurativeVat.getMaster(world, world.func_180495_p(pos), pos);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        Object tile = worldIn.func_175625_s(pos);
        switch (this.func_176201_c(state)) {
            case 1: {
                if (!(tile instanceof TileVat)) break;
                ((TileVat)((Object)tile)).destroyMultiBlock();
                break;
            }
            case 2: {
                tile = worldIn.func_175625_s(pos.func_177981_b(3));
                if (!(tile instanceof TileVat)) break;
                ((TileVat)((Object)tile)).destroyMultiBlock();
                break;
            }
            default: {
                tile = BlockCurativeVat.getMaster(worldIn, state, pos);
                if (!(tile instanceof TileVat) || tile == null) break;
                ((TileVat)((Object)tile)).destroyMultiBlock();
            }
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand != EnumHand.MAIN_HAND) {
            return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileVat) {
            TileVat vat = (TileVat)worldIn.func_175625_s(pos);
            return vat.onBlockRigthClick(playerIn, facing, true);
        }
        TileVat vat = BlockCurativeVat.getMaster(worldIn, pos);
        if (vat != null) {
            return vat.onBlockRigthClick(playerIn, facing, false);
        }
        return true;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        switch (meta) {
            case 1: {
                return new TileVat();
            }
            case 2: {
                return new TileVatBottom();
            }
            case 3: {
                return new TileVatConnector();
            }
        }
        return null;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.getStateFromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public boolean func_176225_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.func_176201_c(state) == Type.BOTTOM.getMetadata();
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.TRANSLUCENT || layer == BlockRenderLayer.SOLID;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean isFullyOpaque(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149751_l(IBlockState state) {
        return true;
    }

    public boolean isVisuallyOpaque() {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public static TileVat getMaster(World world, IBlockState state, BlockPos pos) {
        for (BlockPos pos2 : BlockPos.func_191531_b((int)(pos.func_177958_n() - 1), (int)pos.func_177956_o(), (int)(pos.func_177952_p() - 1), (int)(pos.func_177958_n() + 1), (int)pos.func_177956_o(), (int)(pos.func_177952_p() + 1))) {
            TileEntity te;
            IBlockState state2 = world.func_180495_p(pos2);
            if (state2.func_177230_c() instanceof BlockLiquidVat) {
                state2 = world.func_180495_p(pos2.func_177984_a());
                te = world.func_175625_s(pos2.func_177984_a());
                if (te instanceof TileVat) {
                    return (TileVat)te;
                }
                state2 = world.func_180495_p(pos2.func_177981_b(2));
                te = world.func_175625_s(pos2.func_177981_b(2));
                if (!(te instanceof TileVat)) continue;
                return (TileVat)te;
            }
            if (!(state2.func_177230_c() instanceof BlockCurativeVat)) continue;
            if (state2.func_177230_c().func_176201_c(state2) == 1) {
                te = world.func_175625_s(pos2);
                if (!(te instanceof TileVat)) continue;
            } else if (state2.func_177230_c().func_176201_c(state2) != 2 || !((te = world.func_175625_s(pos2.func_177981_b(3))) instanceof TileVat)) continue;
            return (TileVat)te;
        }
        return null;
    }

    @Override
    public boolean isInCreativeTabs() {
        return false;
    }

    public static final class Type
    extends Enum<Type>
    implements IStringSerializable {
        public static final /* enum */ Type PLACEHOLDER;
        public static final /* enum */ Type TOP;
        public static final /* enum */ Type BOTTOM;
        public static final /* enum */ Type CONNECTOR;
        private static final Type[] METADATA;
        private final String name;
        private final int metadata;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(int metadata, String name) {
            this.metadata = metadata;
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMetadata() {
            return this.metadata;
        }

        public String toString() {
            return this.name;
        }

        public static Type getStateFromMeta(int metadata) {
            if (metadata < 0 || metadata >= METADATA.length) {
                metadata = 0;
            }
            return METADATA[metadata];
        }

        static {
            Type[] var0;
            PLACEHOLDER = new Type(0, "placeholder");
            TOP = new Type(1, "top");
            BOTTOM = new Type(2, "bottom");
            CONNECTOR = new Type(3, "connector");
            $VALUES = new Type[]{PLACEHOLDER, TOP, BOTTOM, CONNECTOR};
            METADATA = new Type[Type.values().length];
            Type[] typeArray = var0 = Type.values();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type type;
                Type.METADATA[type.getMetadata()] = type = typeArray[i];
            }
        }
    }
}

