/*
 * Decompiled with CFR 0.152.
 */
package fr.wind_blade.isorropia.common.capabilities;

import fr.wind_blade.isorropia.common.Common;
import fr.wind_blade.isorropia.common.network.CapabilityMessage;
import fr.wind_blade.isorropia.common.network.TrackingCapabilityMessage;
import fr.wind_blade.isorropia.common.research.recipes.OrganCurativeInfusionRecipe;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class LivingBaseCapability
implements ICapabilityProvider,
INBTSerializable<NBTTagCompound> {
    public EntityLivingBase entity = null;
    public HashMap<ResourceLocation, NBTTagCompound> infusions = new HashMap();
    public int petrification = 0;

    public LivingBaseCapability(EntityLivingBase base) {
        this.entity = base;
    }

    public void update() {
    }

    public boolean entityHasOrgan(OrganCurativeInfusionRecipe.Organ organ, String name) {
        NBTTagCompound nbt = this.infusions.get(new ResourceLocation("isorropia:organs"));
        return nbt != null && nbt.func_74764_b(organ.registryName.toString()) && nbt.func_74779_i(organ.registryName.toString()).equals(name);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagCompound infusions = new NBTTagCompound();
        int i = 0;
        nbt.func_74768_a("petrification", this.petrification);
        for (Map.Entry<ResourceLocation, NBTTagCompound> set : this.infusions.entrySet()) {
            infusions.func_74778_a(Integer.toString(i++), set.getKey().toString());
            infusions.func_74782_a(set.getKey().toString(), (NBTBase)set.getValue());
        }
        nbt.func_74782_a("infusions", (NBTBase)infusions);
        nbt.func_74768_a("infusions_count", i);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        NBTTagCompound infusions = nbt.func_74775_l("infusions");
        int count = nbt.func_74762_e("infusions_count");
        this.petrification = nbt.func_74762_e("petrification");
        for (int i = 0; i < count; ++i) {
            String location = infusions.func_74779_i(Integer.toString(i));
            this.infusions.put(new ResourceLocation(location), (NBTTagCompound)infusions.func_74781_a(location));
        }
    }

    public NBTTagCompound startTrackSerializeNBT() {
        return this.serializeNBT();
    }

    public void startTrackDeserializeNBT(NBTTagCompound nbt) {
        this.deserializeNBT(nbt);
    }

    public void synch(EntityPlayerMP player) {
        Common.INSTANCE.sendTo((IMessage)new CapabilityMessage(this.entity, this.serializeNBT()), player);
    }

    public void synchStartTracking(EntityPlayerMP playerIn) {
        Common.INSTANCE.sendTo((IMessage)new TrackingCapabilityMessage(this.entity, this.startTrackSerializeNBT()), playerIn);
    }

    public void synchToAllTracking() {
        Common.INSTANCE.sendToAllTracking((IMessage)new CapabilityMessage(this.entity), (Entity)this.entity);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == Common.LIVING_BASE_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(this.hasCapability(capability, facing) ? this : null);
    }

    public LivingBaseCapability petrificate(int petrification) {
        this.petrification = Math.min(this.petrification + petrification, 100);
        return this;
    }

    public static class Storage
    implements Capability.IStorage<LivingBaseCapability> {
        public NBTBase writeNBT(Capability<LivingBaseCapability> capability, LivingBaseCapability instance, EnumFacing side) {
            return null;
        }

        public void readNBT(Capability<LivingBaseCapability> capability, LivingBaseCapability instance, EnumFacing side, NBTBase nbt) {
        }
    }

    public static class Factory
    implements Callable<LivingBaseCapability> {
        @Override
        public LivingBaseCapability call() {
            return null;
        }
    }
}

